/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class JMHSample_12_Forking {
    Counter c1 = new Counter1();
    Counter c2 = new Counter2();

    public int measure(Counter c) {
        int s = 0;
        for (int i = 0; i < 10; ++i) {
            s += c.inc();
        }
        return s;
    }

    @Benchmark
    @Fork(value=0)
    public int measure_1_c1() {
        return this.measure(this.c1);
    }

    @Benchmark
    @Fork(value=0)
    public int measure_2_c2() {
        return this.measure(this.c2);
    }

    @Benchmark
    @Fork(value=0)
    public int measure_3_c1_again() {
        return this.measure(this.c1);
    }

    @Benchmark
    @Fork(value=1)
    public int measure_4_forked_c1() {
        return this.measure(this.c1);
    }

    @Benchmark
    @Fork(value=1)
    public int measure_5_forked_c2() {
        return this.measure(this.c2);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSample_12_Forking.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    public static class Counter1
    implements Counter {
        private int x;

        @Override
        public int inc() {
            return this.x++;
        }
    }

    public static interface Counter {
        public int inc();
    }

    public static class Counter2
    implements Counter {
        private int x;

        @Override
        public int inc() {
            return this.x++;
        }
    }
}

