/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.profile.ClassloaderProfiler;
import org.openjdk.jmh.profile.LinuxPerfProfiler;
import org.openjdk.jmh.profile.StackProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class JMHSample_35_Profilers {

    @State(value=Scope.Benchmark)
    @Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
    @Fork(value=1)
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public static class Atomic {
        private AtomicLong n;

        @Setup
        public void setup() {
            this.n = new AtomicLong();
        }

        @Benchmark
        public long test() {
            return this.n.incrementAndGet();
        }

        public static void main(String[] args) throws RunnerException {
            Options opt = new OptionsBuilder().include(Atomic.class.getSimpleName()).addProfiler(LinuxPerfProfiler.class).build();
            new Runner(opt).run();
        }
    }

    @State(value=Scope.Thread)
    @Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
    @Fork(value=3)
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public static class Classy {
        @Benchmark
        public Class<?> load() throws ClassNotFoundException {
            return Class.forName("X", true, new XLoader());
        }

        public static void main(String[] args) throws RunnerException {
            Options opt = new OptionsBuilder().include(Classy.class.getSimpleName()).addProfiler(ClassloaderProfiler.class).build();
            new Runner(opt).run();
        }

        public static class XLoader
        extends URLClassLoader {
            private static final byte[] X_BYTECODE = new byte[]{-54, -2, -70, -66, 0, 0, 0, 52, 0, 13, 10, 0, 3, 0, 10, 7, 0, 11, 7, 0, 12, 1, 0, 6, 60, 105, 110, 105, 116, 62, 1, 0, 3, 40, 41, 86, 1, 0, 4, 67, 111, 100, 101, 1, 0, 15, 76, 105, 110, 101, 78, 117, 109, 98, 101, 114, 84, 97, 98, 108, 101, 1, 0, 10, 83, 111, 117, 114, 99, 101, 70, 105, 108, 101, 1, 0, 6, 88, 46, 106, 97, 118, 97, 12, 0, 4, 0, 5, 1, 0, 1, 88, 1, 0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 0, 32, 0, 2, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 5, 0, 1, 0, 6, 0, 0, 0, 29, 0, 1, 0, 1, 0, 0, 0, 5, 42, -73, 0, 1, -79, 0, 0, 0, 1, 0, 7, 0, 0, 0, 6, 0, 1, 0, 0, 0, 1, 0, 1, 0, 8, 0, 0, 0, 2, 0, 9};

            public XLoader() {
                super(new URL[0], ClassLoader.getSystemClassLoader());
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                return this.defineClass(name, X_BYTECODE, 0, X_BYTECODE.length);
            }
        }
    }

    @State(value=Scope.Thread)
    @Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
    @Fork(value=3)
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public static class Maps {
        private Map<Integer, Integer> map;
        @Param(value={"hashmap", "treemap"})
        private String type;
        private int begin;
        private int end;

        @Setup
        public void setup() {
            switch (this.type) {
                case "hashmap": {
                    this.map = new HashMap<Integer, Integer>();
                    break;
                }
                case "treemap": {
                    this.map = new TreeMap<Integer, Integer>();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + this.type);
                }
            }
            this.begin = 1;
            this.end = 256;
            for (int i = this.begin; i < this.end; ++i) {
                this.map.put(i, i);
            }
        }

        @Benchmark
        public void test(Blackhole bh) {
            for (int i = this.begin; i < this.end; ++i) {
                bh.consume((Object)this.map.get(i));
            }
        }

        public static void main(String[] args) throws RunnerException {
            Options opt = new OptionsBuilder().include(Maps.class.getSimpleName()).addProfiler(StackProfiler.class).build();
            new Runner(opt).run();
        }
    }
}

