/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class JMHSample_24_Inheritance {
    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + JMHSample_24_Inheritance.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }

    public static class BenchmarkCos
    extends AbstractBenchmark {
        @Override
        protected double doWork() {
            return Math.sin(this.x);
        }
    }

    public static class BenchmarkSin
    extends AbstractBenchmark {
        @Override
        protected double doWork() {
            return Math.sin(this.x);
        }
    }

    public static class BenchmarkLog
    extends AbstractBenchmark {
        @Override
        protected double doWork() {
            return Math.log(this.x);
        }
    }

    @BenchmarkMode(value={Mode.AverageTime})
    @Fork(value=1)
    @State(value=Scope.Thread)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public static abstract class AbstractBenchmark {
        public int x = 42;

        @Benchmark
        @Warmup(iterations=5, time=100, timeUnit=TimeUnit.MILLISECONDS)
        @Measurement(iterations=5, time=100, timeUnit=TimeUnit.MILLISECONDS)
        public double bench() {
            return this.doWork() * this.doWork();
        }

        protected abstract double doWork();
    }
}

