/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
public class JMHSample_31_InfraParams {
    static final int THREAD_SLICE = 1000;
    private ConcurrentHashMap<String, String> mapSingle;
    private ConcurrentHashMap<String, String> mapFollowThreads;

    @Setup
    public void setup(BenchmarkParams params) {
        int capacity = 16000 * params.getThreads();
        this.mapSingle = new ConcurrentHashMap(capacity, 0.75f, 1);
        this.mapFollowThreads = new ConcurrentHashMap(capacity, 0.75f, params.getThreads());
    }

    @Benchmark
    public void measureDefault(Ids ids) {
        for (String s : ids.ids) {
            this.mapSingle.remove(s);
            this.mapSingle.put(s, s);
        }
    }

    @Benchmark
    public void measureFollowThreads(Ids ids) {
        for (String s : ids.ids) {
            this.mapFollowThreads.remove(s);
            this.mapFollowThreads.put(s, s);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + JMHSample_31_InfraParams.class.getSimpleName() + ".*").warmupIterations(5).measurementIterations(5).threads(4).forks(5).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class Ids {
        private List<String> ids;

        @Setup
        public void setup(ThreadParams threads) {
            this.ids = new ArrayList<String>();
            for (int c = 0; c < 1000; ++c) {
                this.ids.add("ID" + (1000 * threads.getThreadIndex() + c));
            }
        }
    }
}

