/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openjdk.jmh.annotations.GenerateMicroBenchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.logic.results.Result;
import org.openjdk.jmh.logic.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.parameters.TimeValue;

@State(value=Scope.Thread)
public class JMHSample_25_API_GA {
    private int v;

    @GenerateMicroBenchmark
    public int test() {
        return this.veryImportantCode(1000, this.v);
    }

    public int veryImportantCode(int d, int v) {
        if (d == 0) {
            return v;
        }
        return this.veryImportantCode(d - 1, v);
    }

    public static void main(String[] args) throws RunnerException {
        Options baseOpts = new OptionsBuilder().include(".*" + JMHSample_25_API_GA.class.getName() + ".*").warmupTime(TimeValue.milliseconds((long)200L)).measurementTime(TimeValue.milliseconds((long)200L)).warmupIterations(5).measurementIterations(5).forks(1).verbosity(VerboseMode.SILENT).build();
        Population pop = new Population();
        int POPULATION = 10;
        for (int c = 0; c < 10; ++c) {
            pop.addChromosome(new Chromosome(baseOpts));
        }
        int GENERATIONS = 100;
        for (int g = 0; g < 100; ++g) {
            System.out.println("Entering generation " + g);
            RunResult runner = new Runner(baseOpts).runSingle();
            Result baseResult = runner.getPrimaryResult();
            System.out.println("---------------------------------------");
            System.out.printf("Baseline score: %10.2f %s%n", baseResult.getScore(), baseResult.getScoreUnit());
            for (Chromosome c : pop.getAll()) {
                System.out.printf("%10.2f %s (%+10.2f%%) %s%n", c.getScore(), baseResult.getScoreUnit(), (c.getScore() / baseResult.getScore() - 1.0) * 100.0, c.toString());
            }
            System.out.println();
            Population newPop = new Population();
            int ELITE = 2;
            for (Chromosome c : pop.getAll().subList(0, 2)) {
                newPop.addChromosome(c);
            }
            while (newPop.size() < pop.size()) {
                Chromosome p1 = pop.selectToBreed();
                Chromosome p2 = pop.selectToBreed();
                newPop.addChromosome(p1.crossover(p2).mutate());
                newPop.addChromosome(p2.crossover(p1).mutate());
            }
            pop = newPop;
        }
    }

    public static class Chromosome
    implements Comparable<Chromosome> {
        double score = Double.NEGATIVE_INFINITY;
        final Options baseOpts;
        int freqInlineSize = 325;
        int inlineSmallCode = 1000;
        int maxInlineLevel = 9;
        int maxInlineSize = 35;
        int maxRecursiveInlineLevel = 1;
        int minInliningThreshold = 250;

        public Chromosome(Options baseOpts) {
            this.baseOpts = baseOpts;
        }

        public double score() {
            if (this.score != Double.NEGATIVE_INFINITY) {
                return this.score;
            }
            try {
                Options theseOpts = new OptionsBuilder().parent(this.baseOpts).jvmArgs(this.toString().split("[ ]")).build();
                RunResult runResult = new Runner(theseOpts).runSingle();
                this.score = runResult.getPrimaryResult().getScore();
            }
            catch (RunnerException e) {
                this.score = Double.MIN_VALUE;
            }
            return this.score;
        }

        @Override
        public int compareTo(Chromosome o) {
            return -Double.valueOf(this.score()).compareTo(o.score());
        }

        public String toString() {
            return "-XX:FreqInlineSize=" + this.freqInlineSize + " -XX:InlineSmallCode=" + this.inlineSmallCode + " -XX:MaxInlineLevel=" + this.maxInlineLevel + " -XX:MaxInlineSize=" + this.maxInlineSize + " -XX:MaxRecursiveInlineLevel=" + this.maxRecursiveInlineLevel + " -XX:MinInliningThreshold=" + this.minInliningThreshold;
        }

        public Chromosome crossover(Chromosome other) {
            double CROSSOVER_PROB = 0.1;
            Chromosome result = new Chromosome(this.baseOpts);
            result.freqInlineSize = Math.random() < 0.1 ? this.freqInlineSize : other.freqInlineSize;
            result.inlineSmallCode = Math.random() < 0.1 ? this.inlineSmallCode : other.inlineSmallCode;
            result.maxInlineLevel = Math.random() < 0.1 ? this.maxInlineLevel : other.maxInlineLevel;
            result.maxInlineSize = Math.random() < 0.1 ? this.maxInlineSize : other.maxInlineSize;
            result.maxRecursiveInlineLevel = Math.random() < 0.1 ? this.maxRecursiveInlineLevel : other.maxRecursiveInlineLevel;
            result.minInliningThreshold = Math.random() < 0.1 ? this.minInliningThreshold : other.minInliningThreshold;
            return result;
        }

        public Chromosome mutate() {
            Chromosome result = new Chromosome(this.baseOpts);
            result.freqInlineSize = (int)this.randomChange(this.freqInlineSize);
            result.inlineSmallCode = (int)this.randomChange(this.inlineSmallCode);
            result.maxInlineLevel = (int)this.randomChange(this.maxInlineLevel);
            result.maxInlineSize = (int)this.randomChange(this.maxInlineSize);
            result.maxRecursiveInlineLevel = (int)this.randomChange(this.maxRecursiveInlineLevel);
            result.minInliningThreshold = (int)this.randomChange(this.minInliningThreshold);
            return result;
        }

        private double randomChange(double v) {
            double MUTATE_PROB = 0.5;
            if (Math.random() < 0.5) {
                if (Math.random() < 0.5) {
                    return v / (Math.random() * 2.0);
                }
                return v * (Math.random() * 2.0);
            }
            return v;
        }

        public double getScore() {
            return this.score;
        }
    }

    public static class Population {
        private final List<Chromosome> list = new ArrayList<Chromosome>();

        public void addChromosome(Chromosome c) {
            this.list.add(c);
            Collections.sort(this.list);
        }

        public Chromosome selectToBreed() {
            double totalScore = 0.0;
            for (Chromosome c : this.list) {
                totalScore += c.score();
            }
            double thresh = Math.random() * totalScore;
            for (Chromosome c : this.list) {
                if (thresh < 0.0) {
                    return c;
                }
                thresh = -c.score();
            }
            throw new IllegalStateException("Can not choose");
        }

        public int size() {
            return this.list.size();
        }

        public List<Chromosome> getAll() {
            return this.list;
        }
    }
}

