/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.logic.BlackHole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
public class JMHSample_09_Blackholes {
    double x1 = Math.PI;
    double x2 = Math.PI * 2;

    public double baseline() {
        return Math.log(this.x1);
    }

    public double measureWrong() {
        Math.log(this.x1);
        return Math.log(this.x2);
    }

    public double measureRight_1() {
        return Math.log(this.x1) + Math.log(this.x2);
    }

    public void measureRight_2(BlackHole bh) {
        bh.consume(Math.log(this.x1));
        bh.consume(Math.log(this.x2));
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + JMHSample_09_Blackholes.class.getSimpleName() + ".*").warmupIterations(5).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }
}

