/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.reflection.RFClassInfo;

public class RFGeneratorSource
implements GeneratorSource {
    private final Collection<Class> classes = new ArrayList<Class>();

    public Collection<ClassInfo> getClasses() {
        ArrayList<ClassInfo> cis = new ArrayList<ClassInfo>();
        for (Class c : this.classes) {
            cis.add(new RFClassInfo(c));
        }
        return cis;
    }

    public static ClassInfo resolveClass(Class<?> klass) {
        return new RFClassInfo(klass);
    }

    public ClassInfo resolveClass(String className) {
        String desc = className.replace('/', '.');
        try {
            return RFGeneratorSource.resolveClass(Class.forName(desc, false, Thread.currentThread().getContextClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to resolve class: " + desc);
        }
    }

    public void processClasses(Class ... cs) {
        this.processClasses(Arrays.asList(cs));
    }

    public void processClasses(Collection<Class> cs) {
        this.classes.addAll(cs);
    }
}

