/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.reflection.RFConstructorInfo;
import org.openjdk.jmh.generators.reflection.RFFieldInfo;
import org.openjdk.jmh.generators.reflection.RFMethodInfo;

class RFClassInfo
implements ClassInfo {
    private final Class<?> klass;

    public RFClassInfo(Class<?> klass) {
        this.klass = klass;
    }

    public String getPackageName() {
        if (this.klass.getDeclaringClass() != null) {
            return this.klass.getDeclaringClass().getPackage().getName();
        }
        return this.klass.getPackage().getName();
    }

    public String getName() {
        String name = this.klass.getSimpleName();
        if (name.contains("$")) {
            return name.substring(name.lastIndexOf("$"));
        }
        return name;
    }

    public String getQualifiedName() {
        String name = this.klass.getCanonicalName();
        if (name == null) {
            name = this.klass.getName();
        }
        if (name.contains("$")) {
            return name.replace("$", ".");
        }
        return name;
    }

    public Collection<FieldInfo> getFields() {
        ArrayList<FieldInfo> fis = new ArrayList<FieldInfo>();
        for (Field f : this.klass.getDeclaredFields()) {
            fis.add(new RFFieldInfo(this, f));
        }
        return fis;
    }

    public Collection<MethodInfo> getConstructors() {
        ArrayList<MethodInfo> mis = new ArrayList<MethodInfo>();
        for (Constructor<?> m : this.klass.getDeclaredConstructors()) {
            mis.add(new RFConstructorInfo(this, m));
        }
        return mis;
    }

    public Collection<MethodInfo> getMethods() {
        ArrayList<MethodInfo> mis = new ArrayList<MethodInfo>();
        for (Method m : this.klass.getDeclaredMethods()) {
            mis.add(new RFMethodInfo(this, m));
        }
        return mis;
    }

    public ClassInfo getSuperClass() {
        if (this.klass.getSuperclass() != null) {
            return new RFClassInfo(this.klass.getSuperclass());
        }
        return null;
    }

    public ClassInfo getDeclaringClass() {
        if (this.klass.getDeclaringClass() != null) {
            return new RFClassInfo(this.klass.getDeclaringClass());
        }
        return null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        return this.klass.getAnnotation(annClass);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.klass.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.klass.getModifiers());
    }

    public boolean isStrictFP() {
        return Modifier.isStrict(this.klass.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.klass.getModifiers());
    }

    public boolean isInner() {
        return this.klass.isAnonymousClass() || this.klass.isLocalClass() || this.klass.isMemberClass() && !Modifier.isStatic(this.klass.getModifiers());
    }

    public boolean isEnum() {
        return this.klass.isEnum();
    }

    public Collection<String> getEnumConstants() {
        ArrayList<String> res = new ArrayList<String>();
        for (Object cnst : this.klass.getEnumConstants()) {
            res.add(cnst.toString());
        }
        return res;
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

