/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.reflection.RFClassInfo;

class RFFieldInfo
implements FieldInfo {
    private final ClassInfo declaringClass;
    private final Field f;

    public RFFieldInfo(ClassInfo declaringClass, Field f) {
        this.declaringClass = declaringClass;
        this.f = f;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.f.getName();
    }

    public ClassInfo getType() {
        return new RFClassInfo(this.f.getType());
    }

    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        return this.f.getAnnotation(annClass);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.f.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.f.getModifiers());
    }
}

