/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.reflective;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.ParameterInfo;
import org.openjdk.jmh.generators.reflective.RFClassInfo;
import org.openjdk.jmh.generators.reflective.RFParameterInfo;

class RFMethodInfo
implements MethodInfo {
    private final RFClassInfo declaringClass;
    private final Method m;

    public RFMethodInfo(RFClassInfo declaringClass, Method m) {
        this.declaringClass = declaringClass;
        this.m = m;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.m.getName();
    }

    public String getQualifiedName() {
        return this.declaringClass.getQualifiedName() + "." + this.m.getName();
    }

    public String getReturnType() {
        return this.m.getReturnType().getCanonicalName();
    }

    public Collection<ParameterInfo> getParameters() {
        ArrayList<ParameterInfo> pis = new ArrayList<ParameterInfo>();
        for (Class<?> cl : this.m.getParameterTypes()) {
            pis.add(new RFParameterInfo(cl));
        }
        return pis;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        return this.m.getAnnotation(annClass);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.m.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.m.getModifiers());
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.m.getModifiers());
    }

    public boolean isStrictFP() {
        return Modifier.isStrict(this.m.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.m.getModifiers());
    }

    public int compareTo(MethodInfo o) {
        return this.getQualifiedName().compareTo(o.getQualifiedName());
    }
}

