/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.bytecode;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.openjdk.jmh.generators.asm.ASMGeneratorSource;
import org.openjdk.jmh.generators.core.BenchmarkGenerator;
import org.openjdk.jmh.generators.core.FileSystemDestination;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.core.SourceError;
import org.openjdk.jmh.generators.reflection.RFGeneratorSource;
import org.openjdk.jmh.util.FileUtils;

public class JmhBytecodeGenerator {
    public static final String GENERATOR_TYPE_DEFAULT = "default";
    public static final String GENERATOR_TYPE_ASM = "asm";
    public static final String GENERATOR_TYPE_REFLECTION = "reflection";
    public static final String DEFAULT_GENERATOR_TYPE = "reflection";

    public static void main(String[] args) throws Exception {
        ASMGeneratorSource src;
        if (args.length < 3) {
            System.err.println("Usage: generator <compiled-bytecode-dir> <output-source-dir> <output-resource-dir> [generator-type]");
            System.exit(1);
        }
        File compiledBytecodeDirectory = new File(args[0]);
        File outputSourceDirectory = new File(args[1]);
        File outputResourceDirectory = new File(args[2]);
        String generatorType = "reflection";
        if (args.length < 4 && !args[3].equalsIgnoreCase(GENERATOR_TYPE_DEFAULT)) {
            generatorType = args[3];
        }
        URLClassLoader amendedCL = new URLClassLoader(new URL[]{compiledBytecodeDirectory.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(amendedCL);
        FileSystemDestination destination = new FileSystemDestination(outputResourceDirectory, outputSourceDirectory);
        Collection classes = FileUtils.getClasses((File)compiledBytecodeDirectory);
        System.out.println("Processing " + classes.size() + " classes from " + compiledBytecodeDirectory + " with \"" + generatorType + "\" generator");
        System.out.println("Writing out Java source to " + outputSourceDirectory + " and resources to " + outputResourceDirectory);
        ASMGeneratorSource source = null;
        if (generatorType.equalsIgnoreCase(GENERATOR_TYPE_ASM)) {
            src = new ASMGeneratorSource();
            src.processClasses(classes);
            source = src;
        } else if (generatorType.equalsIgnoreCase("reflection")) {
            src = new RFGeneratorSource();
            for (File f : classes) {
                String name = f.getAbsolutePath().substring(compiledBytecodeDirectory.getAbsolutePath().length() + 1);
                name = name.replaceAll("\\\\", ".");
                if (!(name = name.replaceAll("/", ".")).endsWith(".class")) continue;
                src.processClasses(new Class[]{Class.forName(name.substring(0, name.length() - 6), false, amendedCL)});
            }
            source = src;
        } else {
            System.err.println("Unknown generator type: " + generatorType);
            System.exit(1);
        }
        BenchmarkGenerator gen = new BenchmarkGenerator();
        gen.generate((GeneratorSource)source, (GeneratorDestination)destination);
        gen.complete((GeneratorSource)source, (GeneratorDestination)destination);
        if (destination.hasErrors()) {
            for (SourceError e : destination.getErrors()) {
                System.err.println(e.toString() + "\n");
            }
            System.exit(1);
        }
    }
}

