/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.openjdk.jmh.generators.annotations.APMetadataInfo;
import org.openjdk.jmh.generators.annotations.APParameterInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.ParameterInfo;

public class APMethodInfo
extends APMetadataInfo
implements MethodInfo {
    private final ClassInfo ci;
    private final ExecutableElement el;

    public APMethodInfo(ProcessingEnvironment processEnv, ClassInfo ci, ExecutableElement el) {
        super(processEnv, el);
        this.ci = ci;
        this.el = el;
    }

    public ClassInfo getDeclaringClass() {
        return this.ci;
    }

    public String getName() {
        return this.el.getSimpleName().toString();
    }

    public String getReturnType() {
        return this.el.getReturnType().toString();
    }

    public Collection<ParameterInfo> getParameters() {
        ArrayList<ParameterInfo> pis = new ArrayList<ParameterInfo>();
        for (VariableElement variableElement : this.el.getParameters()) {
            pis.add(new APParameterInfo(this.processEnv, variableElement));
        }
        return pis;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        return this.el.getAnnotation(annClass);
    }

    public boolean isPublic() {
        return this.el.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isAbstract() {
        return this.el.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isSynchronized() {
        return this.el.getModifiers().contains((Object)Modifier.SYNCHRONIZED);
    }

    public boolean isStrictFP() {
        return this.el.getModifiers().contains((Object)Modifier.STRICTFP);
    }

    public boolean isStatic() {
        return this.el.getModifiers().contains((Object)Modifier.STATIC);
    }

    public String getQualifiedName() {
        return this.ci.getQualifiedName() + "." + this.el.toString();
    }

    public int compareTo(MethodInfo o) {
        return this.getQualifiedName().compareTo(o.getQualifiedName());
    }

    public String toString() {
        return this.getDeclaringClass() + " " + this.getName();
    }
}

