/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.test.mock.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openjdk.jmc.common.collection.IteratorToolkit;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.test.mock.item.MockItem;
import org.openjdk.jmc.test.mock.item.MockItemIterable;

public class MockItemCollection<T, CT extends IType<?>>
implements IItemCollection {
    private List<IItem> items = new ArrayList<IItem>();
    private IType<?> type;

    public MockItemCollection(T[] values, IType<?> type) {
        this.build(values, type);
        this.type = type;
    }

    private void build(T[] values, IType<?> type) {
        long index = 0L;
        for (T value : values) {
            this.items.add(new MockItem(value, type, index++));
        }
    }

    public IItemCollection apply(IItemFilter filter) {
        return null;
    }

    public Iterator<IItemIterable> iterator() {
        return IteratorToolkit.of((Object[])new IItemIterable[]{new MockItemIterable(this.items, this.type)});
    }

    public <V, C extends IItemConsumer<C>> V getAggregate(IAggregator<V, C> aggregator) {
        return MockItemCollection.aggregate(aggregator, this.iterator());
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    private static <V, C extends IItemConsumer<C>> V aggregate(final IAggregator<V, C> aggregator, final Iterator<? extends IItemIterable> items) {
        return (V)aggregator.getValue((Object)new Iterator<C>(){
            IItemIterable next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public C next() {
                IItemConsumer calc = aggregator.newItemConsumer(this.next.getType());
                Iterator iterator = this.next.iterator();
                while (iterator.hasNext()) {
                    calc.consume((IItem)iterator.next());
                }
                this.next = this.findNext();
                return calc;
            }

            IItemIterable findNext() {
                while (items.hasNext()) {
                    IItemIterable ii = (IItemIterable)items.next();
                    if (!aggregator.acceptType(ii.getType())) continue;
                    return ii;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public Set<IRange<IQuantity>> getUnfilteredTimeRanges() {
        return Collections.emptySet();
    }
}

