/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.subscription.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.openjdk.jmc.rjmx.common.RJMXCorePlugin;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.common.subscription.IMRITransformation;
import org.openjdk.jmc.rjmx.common.subscription.IMRITransformationFactory;
import org.openjdk.jmc.rjmx.common.subscription.MRI;

public class MRITransformationBaseToolkit {
    protected static final String TRANSFORMATION_EXTENSION_NAME = "org.openjdk.jmc.rjmx.attributeTransformation";
    protected static final String TRANSFORMATION_ELEMENT = "attributeTransformation";
    public static final String TRANSFORMATION_NAME_ATTRIBUTE = "transformationName";
    protected static final String TRANSFORMATION_PROPERTY_ELEMENT = "property";
    protected static final String TRANSFORMATION_PROPERTY_NAME = "name";
    protected static final String TRANSFORMATION_PROPERTY_VALUE = "value";
    protected static final String TRANSFORMATION_PROPERTIES_ELEMENT = "transformationProperties";
    protected static final Map<String, IMRITransformationFactory> TRANSFORMATION_FACTORIES = new HashMap<String, IMRITransformationFactory>();

    public void initializeFromExtensions(Map<String, IMRITransformationFactory> transformationFactories) {
        TRANSFORMATION_FACTORIES.clear();
        for (Map.Entry<String, IMRITransformationFactory> factory : transformationFactories.entrySet()) {
            TRANSFORMATION_FACTORIES.put(factory.getKey(), factory.getValue());
        }
    }

    public static void addTransformationsFactory(String transformationName, IMRITransformationFactory transformationFactory) {
        TRANSFORMATION_FACTORIES.put(transformationName, transformationFactory);
    }

    public static IMRITransformation createTransformation(MRI mri) {
        String transformationName = MRITransformationBaseToolkit.getTransformationName(mri);
        if (TRANSFORMATION_FACTORIES.containsKey(transformationName)) {
            Properties properties = MRITransformationBaseToolkit.createProperties(mri);
            return TRANSFORMATION_FACTORIES.get(transformationName).createTransformation(properties);
        }
        RJMXCorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate unknown transformation type " + transformationName + "!");
        return null;
    }

    public static Iterable<IMRITransformationFactory> getFactories() {
        return Collections.unmodifiableCollection(TRANSFORMATION_FACTORIES.values());
    }

    private static String getTransformationName(MRI mri) {
        String path = mri.getDataPath();
        int partitionIndex = path.indexOf(63);
        if (partitionIndex >= 0) {
            return path.substring(0, partitionIndex);
        }
        return path;
    }

    private static Properties createProperties(MRI mri) {
        Properties properties = new Properties();
        String path = mri.getDataPath();
        int partitionIndex = path.indexOf(63);
        if (partitionIndex >= 0) {
            path = path.substring(partitionIndex + 1);
            for (String property : path.split("&")) {
                int equalIndex = property.indexOf(61);
                properties.put(property.substring(0, equalIndex), property.substring(equalIndex + 1));
            }
        }
        return properties;
    }

    public static void forwardMetadata(IMRIMetadataService metadataService, MRI mri, IMRIMetadata attributeMetadata, String textPattern) {
        metadataService.setMetadata(mri, "DisplayName", String.format(textPattern, attributeMetadata.getMetadata("DisplayName")));
        metadataService.setMetadata(mri, "Description", String.format(textPattern, attributeMetadata.getMetadata("Description")));
        metadataService.setMetadata(mri, "UpdateTime", (String)attributeMetadata.getMetadata("UpdateTime"));
        metadataService.setMetadata(mri, "UnitString", (String)attributeMetadata.getMetadata("UnitString"));
    }
}

