/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import java.util.Objects;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class DelegateErrorHandler
implements ErrorHandler {
    protected ErrorHandler target;

    public DelegateErrorHandler(ErrorHandler target) {
        this.target = target;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (this.target != null) {
            this.target.warning(e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.target != null) {
            this.target.error(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (this.target != null) {
            this.target.fatalError(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DelegateErrorHandler)) {
            return false;
        }
        DelegateErrorHandler that = (DelegateErrorHandler)obj;
        return Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        int hashCode = 1;
        if (this.target != null) {
            hashCode = 31 * hashCode + this.target.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return String.valueOf(this.target);
    }
}

