/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.libj.lang.Classes;
import org.libj.net.URLStreamHandlers;
import org.libj.net.URLs;
import org.libj.util.CollectionUtil;
import org.libj.util.StringPaths;
import org.libj.util.function.Throwing;
import org.openjax.maven.mojo.AnnotationUtil;
import org.openjax.maven.mojo.BaseMojo;
import org.openjax.maven.mojo.FilterParameter;
import org.openjax.maven.mojo.FilterType;
import org.openjax.maven.mojo.MojoUtil;

public abstract class FilterMojo
extends BaseMojo {
    private boolean wasFiltered;
    private Map<String, Object> filteredParameters;

    private static URL filterURL(String value, File baseDir) throws MalformedURLException {
        return StringPaths.isAbsolute((String)value) ? URLs.toCanonicalURL((String)value) : (baseDir != null ? new File(baseDir, value).toURI().toURL() : new File(value).toURI().toURL());
    }

    private static URL filterResource(String value, ClassLoader classLoader) throws MojoExecutionException {
        URL url = classLoader.getResource(value);
        if (url == null) {
            throw new MojoExecutionException("Resource not found in Context ClassLoader: " + value);
        }
        return url;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map<String, Object> getFilterParameters() throws DependencyResolutionRequiredException, MojoExecutionException, MojoFailureException {
        if (this.wasFiltered) {
            return this.filteredParameters;
        }
        this.wasFiltered = true;
        Field[] fields = Classes.getDeclaredFieldsDeep(((Object)((Object)this)).getClass(), (Predicate)Throwing.rethrow(f -> AnnotationUtil.getAnnotationParameters(f, FilterParameter.class) != null));
        if (fields == null || fields.length == 0) {
            return null;
        }
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        HashMap<String, Object> nameToInputs = new HashMap<String, Object>(){

            @Override
            public boolean isEmpty() {
                if (super.isEmpty()) {
                    return true;
                }
                for (Object value : this.values()) {
                    if (value == null || value instanceof List && ((List)value).size() <= 0) continue;
                    return false;
                }
                return true;
            }
        };
        try {
            for (Field field : fields) {
                Object filteredValue;
                void var10_11;
                Parameter parameter = AnnotationUtil.getAnnotationParameters(field, Parameter.class);
                if (parameter == null) {
                    throw new MojoFailureException("@" + FilterParameter.class.getSimpleName() + " annotation can only be used on field having @" + Parameter.class.getSimpleName() + " annotation: " + field.getDeclaringClass().getName() + "." + field.getName());
                }
                boolean isList = List.class.isAssignableFrom(field.getType());
                if (isList) {
                    ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                    Type type = genericType.getActualTypeArguments().length == 0 ? null : genericType.getActualTypeArguments()[0];
                } else {
                    Class<?> clazz = field.getType();
                }
                field.setAccessible(true);
                Object value = field.get((Object)this);
                FilterParameter filterParameter = AnnotationUtil.getAnnotationParameters(field, FilterParameter.class);
                FilterType filterType = filterParameter.value();
                if (filterType == FilterType.FILE) {
                    if (var10_11 != File.class) {
                        throw new IllegalArgumentException("Field specified with @" + FilterParameter.class.getSimpleName() + "(" + FilterType.class.getSimpleName() + ".FILE) must be of type " + File.class.getName() + " or " + List.class.getName() + "<" + File.class.getName() + ">, but found " + var10_11);
                    }
                    filteredValue = value;
                } else {
                    int i;
                    int i$;
                    if (var10_11 != String.class) {
                        throw new IllegalArgumentException("Field specified with @" + FilterParameter.class.getSimpleName() + "(" + FilterType.class.getSimpleName() + ".URL) must be of type String or " + List.class.getName() + "<String>, but found " + var10_11);
                    }
                    if (filterType == FilterType.URL) {
                        File baseDir = project.getBasedir().getAbsoluteFile();
                        if (isList) {
                            filteredValue = value;
                            List values = (List)filteredValue;
                            i$ = values.size();
                            if (i$ > 0) {
                                if (CollectionUtil.isRandomAccess((List)values)) {
                                    i = 0;
                                    do {
                                        values.set(i, FilterMojo.filterURL((String)values.get(i), baseDir).toString());
                                    } while (++i < i$);
                                } else {
                                    i = -1;
                                    Iterator it = values.iterator();
                                    do {
                                        values.set(++i, FilterMojo.filterURL((String)it.next(), baseDir).toString());
                                    } while (it.hasNext());
                                }
                            }
                        } else {
                            filteredValue = FilterMojo.filterURL((String)value, baseDir);
                            field.set((Object)this, value);
                        }
                    } else {
                        if (filterType != FilterType.RESOURCE) throw new UnsupportedOperationException("Unsupported @" + FilterType.class.getSimpleName() + ": " + (Object)((Object)filterType));
                        ArrayList<String> classPaths = new ArrayList<String>();
                        List resources = project.getResources();
                        i$ = resources.size();
                        if (i$ > 0) {
                            if (CollectionUtil.isRandomAccess((List)resources)) {
                                i = 0;
                                do {
                                    classPaths.add(((Resource)resources.get(i)).getDirectory());
                                } while (++i < i$);
                            } else {
                                Iterator it = resources.iterator();
                                do {
                                    classPaths.add(((Resource)it.next()).getDirectory());
                                } while (it.hasNext());
                            }
                        }
                        ArtifactRepository localRepository = this.getSession().getLocalRepository();
                        classPaths.addAll(MojoUtil.getPluginDependencyClassPath((PluginDescriptor)this.getPluginContext().get("pluginDescriptor"), localRepository, (ArtifactHandler)new DefaultArtifactHandler("jar")));
                        classPaths.addAll(project.getRuntimeClasspathElements());
                        classPaths.addAll(project.getCompileClasspathElements());
                        if (this.isInTestPhase()) {
                            List testResources = project.getTestResources();
                            int j$ = testResources.size();
                            if (j$ > 0) {
                                if (CollectionUtil.isRandomAccess((List)testResources)) {
                                    int j = 0;
                                    do {
                                        classPaths.add(((Resource)testResources.get(j)).getDirectory());
                                    } while (++j < j$);
                                } else {
                                    Iterator it = testResources.iterator();
                                    do {
                                        classPaths.add(((Resource)it.next()).getDirectory());
                                    } while (it.hasNext());
                                }
                            }
                            Collections.addAll(classPaths, MojoUtil.getProjectDependencyPaths(project, localRepository));
                            classPaths.addAll(project.getTestClasspathElements());
                        }
                        int len = classPaths.size();
                        URL[] classPathURLs = new URL[len];
                        for (int j = 0; j < len; ++j) {
                            String path = (String)classPaths.get(j);
                            classPathURLs[j] = new URL("file", "", path.endsWith(".jar") ? path : path + "/");
                        }
                        try (URLClassLoader classLoader = new URLClassLoader(classPathURLs, Thread.currentThread().getContextClassLoader());){
                            if (isList) {
                                filteredValue = value;
                                List values = (List)filteredValue;
                                int j$ = values.size();
                                if (j$ > 0) {
                                    int j;
                                    if (CollectionUtil.isRandomAccess((List)values)) {
                                        j = 0;
                                        do {
                                            values.set(j, FilterMojo.filterResource((String)values.get(j), classLoader).toString());
                                        } while (++j < j$);
                                    } else {
                                        j = -1;
                                        Iterator it = values.iterator();
                                        do {
                                            values.set(++j, FilterMojo.filterResource((String)it.next(), classLoader).toString());
                                        } while (it.hasNext());
                                    }
                                }
                            } else {
                                filteredValue = FilterMojo.filterResource((String)value, classLoader).toString();
                                field.set((Object)this, value);
                            }
                        }
                    }
                }
                nameToInputs.put(parameter.property(), filteredValue);
            }
            this.filteredParameters = nameToInputs;
            return this.filteredParameters;
        }
        catch (IOException | IllegalAccessException e) {
            throw new MojoFailureException(null, (Throwable)e);
        }
    }

    @Override
    public final void execute(BaseMojo.Configuration configuration) throws MojoExecutionException, MojoFailureException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String[] classpath = MojoUtil.getProjectDependencyPaths(this.getProject(), this.getSession().getLocalRepository());
        URL[] urls = new URL[classpath.length];
        int i$ = classpath.length;
        for (int i = 0; i < i$; ++i) {
            urls[i] = URLs.create((String)"file", (String)"", (String)classpath[i]);
        }
        try (URLClassLoader dependencyClassLoader2 = new URLClassLoader(urls, contextClassLoader);){
            Thread.currentThread().setContextClassLoader(dependencyClassLoader2);
            this.getFilterParameters();
            this.execute(new Configuration(configuration));
        }
        catch (IOException dependencyClassLoader2) {
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public abstract void execute(Configuration var1) throws MojoExecutionException, MojoFailureException;

    static {
        URLStreamHandlers.loadSPI();
    }

    public static class Configuration
    extends BaseMojo.Configuration {
        public Configuration(BaseMojo.Configuration configuration) {
            super(configuration);
        }
    }
}

