/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.maven.mojo;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public abstract class DeferredLog
implements Log {
    private final ArrayList<Entry> entries = new ArrayList();
    private final Log log;

    public DeferredLog(Log target) {
        this.log = Objects.requireNonNull(target);
    }

    protected abstract void flush(Level var1, CharSequence var2, Throwable var3) throws MojoExecutionException;

    public Log getTarget() {
        return this.log;
    }

    public void flush(Level level) throws MojoExecutionException {
        int i$ = this.entries.size();
        for (int i = 0; i < i$; ++i) {
            Entry entry = this.entries.get(i);
            if (level != null && entry.level.ordinal() > level.ordinal()) continue;
            this.flush(entry.level, entry.content, entry.error);
        }
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(CharSequence content) {
        this.entries.add(new Entry(Level.DEBUG, content, null));
    }

    public void debug(CharSequence content, Throwable error) {
        this.entries.add(new Entry(Level.DEBUG, content, error));
    }

    public void debug(Throwable error) {
        this.entries.add(new Entry(Level.DEBUG, null, error));
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(CharSequence content) {
        this.entries.add(new Entry(Level.INFO, content, null));
    }

    public void info(CharSequence content, Throwable error) {
        this.entries.add(new Entry(Level.INFO, content, error));
    }

    public void info(Throwable error) {
        this.entries.add(new Entry(Level.INFO, null, error));
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void warn(CharSequence content) {
        this.entries.add(new Entry(Level.WARN, content, null));
    }

    public void warn(CharSequence content, Throwable error) {
        this.entries.add(new Entry(Level.WARN, content, error));
    }

    public void warn(Throwable error) {
        this.entries.add(new Entry(Level.WARN, null, error));
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void error(CharSequence content) {
        this.entries.add(new Entry(Level.ERROR, content, null));
    }

    public void error(CharSequence content, Throwable error) {
        this.entries.add(new Entry(Level.ERROR, content, error));
    }

    public void error(Throwable error) {
        this.entries.add(new Entry(Level.ERROR, null, error));
    }

    private class Entry {
        private final Level level;
        private final CharSequence content;
        private final Throwable error;

        private Entry(Level level, CharSequence content, Throwable error) {
            this.level = level;
            this.content = content;
            this.error = error;
        }
    }

    public static enum Level {
        DEBUG{

            @Override
            public void flush(Log log, CharSequence content, Throwable error) {
                log.debug(content, error);
            }
        }
        ,
        INFO{

            @Override
            public void flush(Log log, CharSequence content, Throwable error) {
                log.info(content, error);
            }
        }
        ,
        WARN{

            @Override
            public void flush(Log log, CharSequence content, Throwable error) {
                log.warn(content, error);
            }
        }
        ,
        ERROR{

            @Override
            public void flush(Log log, CharSequence content, Throwable error) {
                log.error(content, error);
            }
        };


        public abstract void flush(Log var1, CharSequence var2, Throwable var3);
    }
}

