/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.maven.mojo;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openjax.maven.mojo.MojoUtil;

@Mojo(name="base")
public abstract class BaseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution execution;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings.offline}", required=true, readonly=true)
    private boolean offline;
    @Parameter(property="failOnNoOp")
    private boolean failOnNoOp = true;
    @Parameter(property="skipTests")
    private boolean skipTests = false;
    @Parameter(property="maven.test.skip.exec")
    private boolean mavenTestSkipExec = false;
    @Parameter(property="maven.test.skip")
    private boolean mavenTestSkip = false;
    @Parameter(property="skip")
    private boolean skip = false;
    private Boolean inTestPhase;

    protected MojoExecution getExecution() {
        return this.execution;
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected boolean getOffline() {
        return this.offline;
    }

    protected boolean getFailOnNoOp() {
        return this.failOnNoOp;
    }

    protected boolean getMavenTestSkipExec() {
        return this.mavenTestSkipExec;
    }

    protected boolean getMavenTestSkip() {
        return this.mavenTestSkip;
    }

    protected boolean getSkip() {
        return this.skip;
    }

    protected Boolean getInTestPhase() {
        return this.inTestPhase;
    }

    protected final boolean isInTestPhase() {
        return this.inTestPhase == null ? (this.inTestPhase = Boolean.valueOf(MojoUtil.isInTestPhase(this.getExecution()))) : this.inTestPhase;
    }

    protected final boolean isSkipTests() {
        return this.skipTests || this.mavenTestSkipExec;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipped (skip=true)");
            return;
        }
        if (MojoUtil.shouldSkip(this.getExecution(), this.mavenTestSkip)) {
            this.getLog().info((CharSequence)"Tests are skipped (maven.test.skip=true)");
            return;
        }
        this.execute(new Configuration(this.failOnNoOp));
    }

    public abstract void execute(Configuration var1) throws MojoExecutionException, MojoFailureException;

    public static class Configuration {
        private final boolean failOnNoOp;

        public Configuration(Configuration configuration) {
            this.failOnNoOp = configuration.failOnNoOp;
        }

        private Configuration(boolean failOnNoOp) {
            this.failOnNoOp = failOnNoOp;
        }

        public boolean getFailOnNoOp() {
            return this.failOnNoOp;
        }
    }
}

