/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.pixels;

import org.openimaj.image.FImage;
import org.openimaj.video.analyser.VideoAnalyser;

public class FMeanVarianceField
extends VideoAnalyser<FImage> {
    private FImage mean;
    private FImage m2;
    private int n;

    public void analyseFrame(FImage frame) {
        int width = frame.width;
        int height = frame.height;
        if (this.mean == null || this.mean.width != width || this.mean.height != height) {
            this.n = 0;
            this.mean = new FImage(width, height);
            this.m2 = new FImage(width, height);
        }
        float[][] mp = this.mean.pixels;
        float[][] m2p = this.m2.pixels;
        float[][] fp = frame.pixels;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float v = fp[y][x];
                float delta = v - mp[y][x];
                ++this.n;
                mp[y][x] = mp[y][x] + delta / (float)this.n;
                m2p[y][x] = m2p[y][x] + delta * (v - mp[y][x]);
            }
        }
    }

    public void reset() {
        this.mean = null;
        this.m2 = null;
    }

    public FImage getMean() {
        return this.mean;
    }

    public FImage getVariance() {
        if (this.m2 == null) {
            return null;
        }
        return (FImage)this.m2.divide((Object)Float.valueOf(this.n - 1));
    }
}

