/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.effects;

import java.util.LinkedList;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processing.convolution.FImageConvolveSeparable;
import org.openimaj.video.Video;
import org.openimaj.video.processor.VideoProcessor;

public class SlitScanProcessor
extends VideoProcessor<MBFImage> {
    LinkedList<float[][][]> cache = new LinkedList();
    final float[] blurKern = FGaussianConvolve.makeKernel((float)0.5f);
    int cacheSize = 240;

    public SlitScanProcessor(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public SlitScanProcessor(Video<MBFImage> video, int cacheSize) {
        super(video);
        this.cacheSize = cacheSize;
    }

    public MBFImage processFrame(MBFImage frame) {
        int index;
        this.addToCache(frame);
        int height = frame.getHeight();
        float prop = (float)this.cacheSize / (float)height;
        frame.fill(RGBColour.BLACK);
        float[][] framer = ((FImage)frame.getBand((int)0)).pixels;
        float[][] frameg = ((FImage)frame.getBand((int)1)).pixels;
        float[][] frameb = ((FImage)frame.getBand((int)2)).pixels;
        for (int y = 0; y < height && (index = (int)((float)y * prop)) < this.cache.size(); ++y) {
            float[][][] cacheImage = this.cache.get(index);
            System.arraycopy(cacheImage[0][y], 0, framer[y], 0, cacheImage[0][y].length);
            System.arraycopy(cacheImage[1][y], 0, frameg[y], 0, cacheImage[1][y].length);
            System.arraycopy(cacheImage[2][y], 0, frameb[y], 0, cacheImage[2][y].length);
        }
        for (FImage f : frame.bands) {
            FImageConvolveSeparable.convolveVertical((FImage)f, (float[])this.blurKern);
        }
        if (this.cache.size() >= this.cacheSize) {
            this.cache.removeLast();
        }
        return frame;
    }

    private void addToCache(MBFImage frame) {
        MBFImage f = (MBFImage)frame.clone();
        float[][][] entry = new float[][][]{((FImage)f.getBand((int)0)).pixels, ((FImage)f.getBand((int)1)).pixels, ((FImage)f.getBand((int)2)).pixels};
        this.cache.addFirst(entry);
    }
}

