/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.tools.web;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Dmoz2CSV {
    static String escape(String input) {
        input = input.replaceAll("\n", " ");
        if ((input = input.replaceAll("\r", " ")).contains(",") || input.contains("\"") || !input.trim().equals(input)) {
            return '\"' + input.replaceAll("\"", "\"\"") + '\"';
        }
        return input;
    }

    static String toCSV(Object ... values) {
        ArrayList<String> escapedValues = new ArrayList<String>();
        for (Object o : values) {
            escapedValues.add(Dmoz2CSV.escape(o.toString()));
        }
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < escapedValues.size(); ++i) {
            content.append((String)escapedValues.get(i));
            if (i >= escapedValues.size() - 1) continue;
            content.append(",");
        }
        content.append("\r\n");
        return content.toString();
    }

    public static void main(String[] args) throws SAXException, ParserConfigurationException, IOException {
        RecordsHandler handler = new RecordsHandler();
        XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        reader.setContentHandler(handler);
        for (String file : args) {
            InputSource is = new InputSource(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            is.setEncoding("UTF-8");
            reader.parse(is);
            for (Topic top : handler.topics) {
                for (String it : top.link1) {
                    System.out.println(Dmoz2CSV.toCSV(top.name, "LINK1", it, handler.resources.get((Object)it).title, handler.resources.get((Object)it).description));
                }
                for (String it : top.link) {
                    System.out.println(Dmoz2CSV.toCSV(top.name, "LINK", it, handler.resources.get((Object)it).title, handler.resources.get((Object)it).description));
                }
            }
        }
    }

    static class RecordsHandler
    extends DefaultHandler {
        Set<Topic> topics = new HashSet<Topic>();
        Map<String, ExternalPage> resources = new HashMap<String, ExternalPage>();
        Topic currentTopic = null;
        ExternalPage currentResource = null;
        boolean isTitle = false;
        boolean isDescription = false;

        RecordsHandler() {
        }

        @Override
        public void startElement(String ns, String localName, String qName, Attributes atts) {
            if (qName.equals("Topic")) {
                this.currentTopic = new Topic();
                this.currentTopic.name = atts.getValue("r:id");
            } else if (qName.equals("link")) {
                this.currentTopic.link.add(atts.getValue("r:resource"));
            } else if (qName.equals("link1")) {
                this.currentTopic.link1.add(atts.getValue("r:resource"));
            } else if (qName.equals("ExternalPage")) {
                this.currentResource = new ExternalPage();
                this.currentResource.about = atts.getValue("about");
            } else if (qName.equals("d:Title")) {
                this.isTitle = true;
            } else if (qName.equals("d:Description")) {
                this.isDescription = true;
            }
        }

        @Override
        public void characters(char[] chars, int offset, int length) {
            if (this.isDescription) {
                this.currentResource.description = new String(chars, offset, length);
            }
            if (this.isTitle) {
                this.currentResource.title = new String(chars, offset, length);
            }
            this.isTitle = false;
            this.isDescription = false;
        }

        @Override
        public void endElement(String ns, String localName, String qName) {
            if (qName.equals("Topic")) {
                if (this.currentTopic.link.size() > 0 && this.currentTopic.link1.size() > 0) {
                    this.topics.add(this.currentTopic);
                }
            } else if (qName.equals("ExternalPage")) {
                this.resources.put(this.currentResource.about, this.currentResource);
            }
        }
    }

    static class ExternalPage {
        String about;
        String title;
        String description;

        ExternalPage() {
        }
    }

    static class Topic {
        String name;
        List<String> link = new ArrayList<String>();
        List<String> link1 = new ArrayList<String>();

        Topic() {
        }
    }
}

