/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotators;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import org.openimaj.text.nlp.textpipe.annotations.AnnotationUtils;
import org.openimaj.text.nlp.textpipe.annotations.PhraseAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.RawTextAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.TokenAnnotation;
import org.openimaj.text.nlp.textpipe.annotators.AbstractPhraseAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.MissingRequiredAnnotationException;

public class OpenNLPPhraseChunkAnnotator
extends AbstractPhraseAnnotator {
    public static final String PHRASE_MODEL_PROP = "org.openimaj.text.opennlp.models.chunker";
    ChunkerME chunker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenNLPPhraseChunkAnnotator() {
        InputStream modelIn = null;
        ChunkerModel model = null;
        try {
            modelIn = OpenNLPPhraseChunkAnnotator.class.getResourceAsStream(System.getProperty(PHRASE_MODEL_PROP));
            model = new ChunkerModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    modelIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.chunker = new ChunkerME(model);
    }

    @Override
    protected void phraseChunk(List<TokenAnnotation> tokens) {
        String[] tags = this.chunker.chunk(AnnotationUtils.ListToArray(AnnotationUtils.getStringTokensFromTokenAnnotationList(tokens)), AnnotationUtils.ListToArray(AnnotationUtils.getStringPOSsFromTokenAnnotationList(tokens)));
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].contains("-")) {
                String[] comps = tags[i].split("-");
                boolean start = comps[0].equals("B");
                tokens.get(i).addAnnotation(new PhraseAnnotation(PhraseAnnotation.Phrase.getPhrasefromString(comps[1]), start));
                continue;
            }
            tokens.get(i).addAnnotation(new PhraseAnnotation(PhraseAnnotation.Phrase.getPhrasefromString(tags[i]), true));
        }
    }

    @Override
    void checkForRequiredAnnotations(RawTextAnnotation annotation) throws MissingRequiredAnnotationException {
    }
}

