/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class TextPipeAnnotation {
    private HashMap<Class<? extends TextPipeAnnotation>, List<TextPipeAnnotation>> annotations = new HashMap();

    public <T extends TextPipeAnnotation> void addAnnotation(T annotation) {
        if (this.annotations.containsKey(annotation.getClass())) {
            this.annotations.get(annotation.getClass()).add(annotation);
        } else {
            ArrayList<T> annos = new ArrayList<T>();
            annos.add(annotation);
            this.annotations.put(annotation.getClass(), annos);
        }
    }

    public <T extends TextPipeAnnotation> void addAllAnnotations(Collection<T> annotationCollection) {
        if (annotationCollection != null && annotationCollection.size() > 0) {
            Class<?> key = ((TextPipeAnnotation)annotationCollection.iterator().next()).getClass();
            if (this.annotations.containsKey(key)) {
                this.annotations.get(key).addAll(annotationCollection);
            } else {
                ArrayList<T> annos = new ArrayList<T>();
                annos.addAll(annotationCollection);
                this.annotations.put(key, annos);
            }
        }
    }

    public <T extends TextPipeAnnotation> List<T> getAnnotationsFor(Class<T> key) {
        if (this.annotations.containsKey(key)) {
            return this.annotations.get(key);
        }
        return null;
    }

    public Set<Class<? extends TextPipeAnnotation>> getAnnotationKeyList() {
        return this.annotations.keySet();
    }
}

