/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment.type;

import java.util.HashMap;
import java.util.Map;
import org.openimaj.text.nlp.sentiment.type.BipolarSentiment;
import org.openimaj.text.nlp.sentiment.type.BipolarSentimentProvider;
import org.openimaj.text.nlp.sentiment.type.InvalidSentimentException;
import org.openimaj.text.nlp.sentiment.type.Sentiment;
import org.openimaj.text.nlp.sentiment.type.UnrecognisedMapException;
import org.openimaj.text.nlp.sentiment.type.WeightedBipolarSentiment;
import org.openimaj.text.nlp.sentiment.type.WeightedBipolarSentimentProvider;
import org.openimaj.util.math.ObjectArithmetic;
import org.openimaj.util.math.ScalarArithmetic;

public class DiscreteCountBipolarSentiment
implements Sentiment,
BipolarSentimentProvider,
WeightedBipolarSentimentProvider,
ScalarArithmetic<DiscreteCountBipolarSentiment, Integer>,
ObjectArithmetic<DiscreteCountBipolarSentiment> {
    public static final DiscreteCountBipolarSentiment POSITIVE = new DiscreteCountBipolarSentiment(1, 0, 0);
    public static final DiscreteCountBipolarSentiment NEGATIVE = new DiscreteCountBipolarSentiment(0, 1, 0);
    public static final DiscreteCountBipolarSentiment NEUTRAL = new DiscreteCountBipolarSentiment(0, 0, 1);
    private int positive;
    private int negative;
    private int neutral;
    private int total;

    public DiscreteCountBipolarSentiment() {
    }

    public DiscreteCountBipolarSentiment(int positive, int negative, int neutral, int total) throws InvalidSentimentException {
        this.positive = positive;
        this.negative = negative;
        this.neutral = neutral;
        this.total = total;
        if (positive + neutral + negative > total) {
            throw new InvalidSentimentException("total counts was less than the total of positive, negative and neutral, this is impossible");
        }
    }

    public DiscreteCountBipolarSentiment(int positive, int negative, int neutral) {
        this.positive = positive;
        this.negative = negative;
        this.neutral = neutral;
        this.total = positive + negative + neutral;
    }

    public int positive() {
        return this.positive;
    }

    public int negative() {
        return this.negative;
    }

    public int neutral() {
        return this.neutral;
    }

    @Override
    public BipolarSentiment bipolar() {
        if (this.positive > this.negative) {
            if (this.positive > this.neutral) {
                return BipolarSentiment.POSITIVE;
            }
            return BipolarSentiment.NEUTRAL;
        }
        if (this.negative > this.neutral) {
            return BipolarSentiment.NEGATIVE;
        }
        return BipolarSentiment.NEUTRAL;
    }

    @Override
    public BipolarSentiment bipolar(double deltaThresh) {
        if ((double)this.positive > (double)this.negative * deltaThresh) {
            if ((double)this.positive > (double)this.neutral * deltaThresh) {
                return BipolarSentiment.POSITIVE;
            }
            if ((double)this.neutral > (double)this.positive * deltaThresh) {
                return BipolarSentiment.NEUTRAL;
            }
        } else {
            if ((double)this.negative > (double)this.neutral * deltaThresh) {
                return BipolarSentiment.NEGATIVE;
            }
            if ((double)this.neutral > (double)this.negative * deltaThresh) {
                return BipolarSentiment.NEUTRAL;
            }
        }
        return null;
    }

    @Override
    public Map<String, ?> asMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("positive", this.positive);
        ret.put("negative", this.negative);
        ret.put("neutral", this.neutral);
        ret.put("total", this.total);
        return ret;
    }

    @Override
    public void fromMap(Map<String, ?> map) throws UnrecognisedMapException {
        if (!(map.containsKey("positive") && map.containsKey("negative") && map.containsKey("neutral"))) {
            throw new UnrecognisedMapException("positive", "negative", "neutral");
        }
        this.positive = (Integer)map.get("positive");
        this.negative = (Integer)map.get("negative");
        this.neutral = (Integer)map.get("neutral");
        this.total = (Integer)map.get("total");
    }

    @Override
    public WeightedBipolarSentiment weightedBipolar() {
        return new WeightedBipolarSentiment((double)this.positive / (double)this.total, (double)this.negative / (double)this.total, (double)this.neutral / (double)this.total);
    }

    protected DiscreteCountBipolarSentiment clone() {
        try {
            return new DiscreteCountBipolarSentiment(this.positive, this.negative, this.neutral, this.total);
        }
        catch (InvalidSentimentException e) {
            return null;
        }
    }

    public DiscreteCountBipolarSentiment addInplace(DiscreteCountBipolarSentiment s) {
        this.positive += s.positive;
        this.negative += s.negative;
        this.neutral += s.neutral;
        return this;
    }

    public DiscreteCountBipolarSentiment multiplyInplace(DiscreteCountBipolarSentiment s) {
        this.positive *= s.positive;
        this.negative *= s.negative;
        this.neutral *= s.neutral;
        return this;
    }

    public DiscreteCountBipolarSentiment divideInplace(DiscreteCountBipolarSentiment s) {
        this.positive /= s.positive;
        this.negative /= s.negative;
        this.neutral /= s.neutral;
        return this;
    }

    public DiscreteCountBipolarSentiment add(DiscreteCountBipolarSentiment s) {
        DiscreteCountBipolarSentiment c = this.clone();
        return c.addInplace(s);
    }

    public DiscreteCountBipolarSentiment subtract(DiscreteCountBipolarSentiment s) {
        return this.add(s.multiply(-1));
    }

    public DiscreteCountBipolarSentiment subtractInplace(DiscreteCountBipolarSentiment s) {
        return this.addInplace(s.multiply(-1));
    }

    public DiscreteCountBipolarSentiment multiply(DiscreteCountBipolarSentiment s) {
        return this.clone().multiplyInplace(s);
    }

    public DiscreteCountBipolarSentiment divide(DiscreteCountBipolarSentiment s) {
        return this.clone().divideInplace(s);
    }

    public DiscreteCountBipolarSentiment addInplace(Integer s) {
        this.positive += s.intValue();
        this.negative += s.intValue();
        this.neutral += s.intValue();
        return this;
    }

    public DiscreteCountBipolarSentiment multiplyInplace(Integer s) {
        this.positive *= s.intValue();
        this.negative *= s.intValue();
        this.neutral *= s.intValue();
        return this;
    }

    public DiscreteCountBipolarSentiment divideInplace(Integer s) {
        this.positive /= s.intValue();
        this.negative /= s.intValue();
        this.neutral /= s.intValue();
        return this;
    }

    public DiscreteCountBipolarSentiment add(Integer s) {
        DiscreteCountBipolarSentiment c = this.clone();
        return c.addInplace(s);
    }

    public DiscreteCountBipolarSentiment subtract(Integer s) {
        return this.add(s * -1);
    }

    public DiscreteCountBipolarSentiment subtractInplace(Integer s) {
        return this.addInplace(s * -1);
    }

    public DiscreteCountBipolarSentiment multiply(Integer s) {
        return this.clone().multiplyInplace(s);
    }

    public DiscreteCountBipolarSentiment divide(Integer s) {
        return this.clone().divideInplace(s);
    }

    public String toString() {
        String frmt = "Positive == %d\nNegative == %d\nNetural == %d";
        return String.format(frmt, this.positive, this.negative, this.neutral);
    }
}

