/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.openimaj.text.nlp.namedentity.EntityContextScorer;
import org.openimaj.text.nlp.namedentity.IgnoreTokenStripper;
import org.openimaj.text.nlp.namedentity.NamedEntity;
import org.openimaj.text.nlp.namedentity.QuickSearcher;

public class YagoEntityContextScorerFactory {
    public static YagoEntityContextScorer createFromIndexFile(String indexPath) {
        YagoEntityContextScorer yci = new YagoEntityContextScorer();
        File f = new File(indexPath);
        if (f.isDirectory()) {
            try {
                yci.index = (Directory)new SimpleFSDirectory(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return yci;
    }

    public static class YagoEntityContextScorer
    extends EntityContextScorer<List<String>, NamedEntity> {
        private Directory index = null;
        public final String[] names = new String[]{"uri", "context", "type"};
        private FieldType[] types;
        private IgnoreTokenStripper ss;
        private QuickSearcher qs;

        private YagoEntityContextScorer() {
            FieldType ti = new FieldType();
            ti.setIndexed(true);
            ti.setTokenized(true);
            ti.setStored(true);
            FieldType n = new FieldType();
            n.setStored(true);
            n.setIndexed(true);
            this.types = new FieldType[3];
            this.types[0] = n;
            this.types[1] = ti;
            this.ss = new IgnoreTokenStripper(IgnoreTokenStripper.Language.English);
            this.qs = null;
        }

        @Override
        public HashMap<NamedEntity, Float> getScoredEntitiesFromContext(List<String> context) {
            if (this.qs == null) {
                this.instantiateQS();
            }
            String contextString = StringUtils.join(this.ss.getNonStopWords(context), (String)" ");
            try {
                String[] retFields = new String[]{this.names[0], this.names[2]};
                HashMap<String[], Float> searchresults = this.qs.search(this.names[1], retFields, contextString, 1);
                HashMap<NamedEntity, Float> results = new HashMap<NamedEntity, Float>();
                for (String[] srv : searchresults.keySet()) {
                    NamedEntity yne = new NamedEntity(srv[0], Enum.valueOf(NamedEntity.Type.class, srv[1]));
                    results.put(yne, searchresults.get(srv));
                }
                return results;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public Map<NamedEntity, Float> getScoresForEntityList(List<String> entityUris, List<String> context) {
            if (this.qs == null) {
                this.instantiateQS();
            }
            String contextString = StringUtils.join(this.ss.getNonStopWords(context), (String)" ");
            if (entityUris.size() > 0) {
                String[] retFields = new String[]{this.names[0], this.names[2]};
                HashMap<String[], Float> searchresults = this.qs.searchFiltered(this.names[1], retFields, contextString, this.names[0], entityUris);
                HashMap<NamedEntity, Float> results = new HashMap<NamedEntity, Float>();
                for (String[] srv : searchresults.keySet()) {
                    NamedEntity yne = new NamedEntity(srv[0], Enum.valueOf(NamedEntity.Type.class, srv[1]));
                    results.put(yne, searchresults.get(srv));
                }
                return results;
            }
            return new HashMap<NamedEntity, Float>();
        }

        @Override
        public Map<NamedEntity, Float> getScoresForEntityList(List<String> entityUris, String context) {
            if (this.qs == null) {
                this.instantiateQS();
            }
            if (entityUris.size() > 0) {
                String[] retFields = new String[]{this.names[0], this.names[2]};
                HashMap<String[], Float> searchresults = this.qs.searchFiltered(this.names[1], retFields, context, this.names[0], entityUris);
                HashMap<NamedEntity, Float> results = new HashMap<NamedEntity, Float>();
                for (String[] srv : searchresults.keySet()) {
                    NamedEntity yne = new NamedEntity(srv[0], Enum.valueOf(NamedEntity.Type.class, srv[1]));
                    results.put(yne, searchresults.get(srv));
                }
                return results;
            }
            return new HashMap<NamedEntity, Float>();
        }

        private void instantiateQS() {
            this.qs = new QuickSearcher(this.index, (Analyzer)new StandardAnalyzer(Version.LUCENE_40));
        }
    }
}

