/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.language;

import Jama.Matrix;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class MarkovChainLanguageModel {
    private Map<Locale, Matrix> chains = new HashMap<Locale, Matrix>();
    private Map<Locale, long[]> chainCounts = new HashMap<Locale, long[]>();

    public MarkovChainLanguageModel() {
        this.chains = new HashMap<Locale, Matrix>();
        this.chainCounts = new HashMap<Locale, long[]>();
    }

    public void train(Locale language, String example, String encoding) throws UnsupportedEncodingException {
        if (!this.chains.containsKey(language)) {
            this.chains.put(language, new Matrix(257, 257));
            this.chainCounts.put(language, new long[257]);
        }
        Matrix chain = this.chains.get(language);
        long[] chainCount = this.chainCounts.get(language);
        byte[] data = example.getBytes(encoding);
        int currentIndex = 0;
        double[][] chainData = chain.getArray();
        for (byte b : data) {
            int newIndex = (b & 0xFF) + 1;
            chainData[currentIndex][newIndex] = chainData[currentIndex][newIndex] + 1.0;
            int n = currentIndex;
            chainCount[n] = chainCount[n] + 1L;
            currentIndex = newIndex;
        }
    }

    public void train(Locale language, InputStream stream) throws IOException {
        if (!this.chains.containsKey(language)) {
            this.chains.put(language, new Matrix(257, 257));
            this.chainCounts.put(language, new long[257]);
        }
        Matrix chain = this.chains.get(language);
        long[] chainCount = this.chainCounts.get(language);
        int currentIndex = 0;
        double[][] chainData = chain.getArray();
        int newIndex = -1;
        while ((newIndex = stream.read()) != -1) {
            chainData[currentIndex][++newIndex] = chainData[currentIndex][newIndex] + 1.0;
            int n = currentIndex;
            chainCount[n] = chainCount[n] + 1L;
            currentIndex = newIndex;
        }
    }

    public String generate(Locale language, int length, String encoding) throws UnsupportedEncodingException {
        Matrix chain = this.chains.get(language);
        if (chain == null) {
            return null;
        }
        double[][] chainData = chain.getArray();
        long[] chainCount = this.chainCounts.get(language);
        int currentIndex = 0;
        byte[] newString = new byte[length];
        Random r = new Random();
        for (int i = 0; i < length; ++i) {
            double prob = r.nextDouble();
            double[] currentLine = chainData[currentIndex];
            double probSum = 0.0;
            int newIndex = 0;
            while (probSum + currentLine[newIndex] / (double)chainCount[currentIndex] < prob) {
                double probForIndex = currentLine[newIndex++] / (double)chainCount[currentIndex];
                probSum += probForIndex;
            }
            newString[i] = (byte)(newIndex - 1);
            currentIndex = newIndex;
        }
        return new String(newString, encoding);
    }
}

