/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.basic;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.BatchAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.ml.annotation.basic.util.NumAnnotationsChooser;

public class UniformRandomAnnotator<OBJECT, ANNOTATION>
extends BatchAnnotator<OBJECT, ANNOTATION> {
    protected List<ANNOTATION> annotations;
    protected NumAnnotationsChooser numAnnotations;
    protected Uniform rnd;

    public UniformRandomAnnotator(NumAnnotationsChooser chooser) {
        this.numAnnotations = chooser;
    }

    @Override
    public void train(List<? extends Annotated<OBJECT, ANNOTATION>> data) {
        HashSet<ANNOTATION> annotationsSet = new HashSet<ANNOTATION>();
        TIntIntHashMap nAnnotationCounts = new TIntIntHashMap();
        int maxVal = 0;
        for (Annotated<OBJECT, ANNOTATION> sample : data) {
            Collection<ANNOTATION> annos = sample.getAnnotations();
            annotationsSet.addAll(annos);
            nAnnotationCounts.adjustOrPutValue(annos.size(), 1, 1);
            if (annos.size() <= maxVal) continue;
            maxVal = annos.size();
        }
        this.annotations = new ArrayList<ANNOTATION>(annotationsSet);
        this.rnd = new Uniform(0.0, (double)(this.annotations.size() - 1), (RandomEngine)new MersenneTwister());
        this.numAnnotations.train(data);
    }

    @Override
    public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT image) {
        int nAnnotations = this.numAnnotations.numAnnotations();
        ArrayList<ScoredAnnotation<ANNOTATION>> annos = new ArrayList<ScoredAnnotation<ANNOTATION>>();
        for (int i = 0; i < nAnnotations; ++i) {
            int annotationIdx = this.rnd.nextInt();
            annos.add(new ScoredAnnotation<ANNOTATION>(this.annotations.get(annotationIdx), 1.0f / (float)this.annotations.size()));
        }
        return annos;
    }

    @Override
    public Set<ANNOTATION> getAnnotations() {
        return new HashSet<ANNOTATION>(this.annotations);
    }
}

