/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt;

class IOUtils {
    static String warning_line = "!!! Warning:  This is a KLT data file. Do not modify below this line !!!\n";
    static String binheader_fl = "KLTFL1";
    static String binheader_fh = "KLTFH1";
    static String binheader_ft = "KLTFT1";

    private IOUtils() {
    }

    static String[] setupTxtFormat(String fmt) {
        int val_width = 5;
        if (fmt.charAt(0) != '%') {
            throw new RuntimeException(String.format("(KLTWriteFeatures) Bad Format: %s\n", fmt));
        }
        String type = fmt.substring(fmt.length() - 1);
        if (!type.equals("f") && !type.equals("d")) {
            throw new RuntimeException("(KLTWriteFeatures) Format must end in 'f' or 'd'.");
        }
        String format = String.format("(%s,%s)=%%%dd ", fmt, fmt, 5);
        return new String[]{format, type};
    }

    static String getNhyphens(int n) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + "-";
        }
        return s;
    }

    static String getInteger(int integer, int width) {
        String fmt = String.format("%%%dd", width);
        return String.format(fmt, integer);
    }

    private static int findStringWidth(String str) {
        int width = 0;
        int maxi = str.length() - 1;
        int i = 0;
        while (i <= maxi) {
            if (str.charAt(i) == '%') {
                if (Character.isDigit(str.charAt(i + 1))) {
                    int stop;
                    for (stop = i + 2; stop <= maxi && Character.isDigit(str.charAt(stop)); ++stop) {
                    }
                    int add = Integer.parseInt(str.substring(i + 1, stop));
                    width += add;
                    i += 2;
                    while (!"diouxefgn".contains(str.charAt(i) + "")) {
                        if (++i <= maxi) continue;
                        throw new RuntimeException(String.format("(_findStringWidth) Can't determine length of string '%s'", str));
                    }
                    ++i;
                    continue;
                }
                if (str.charAt(i + 1) == 'c') {
                    ++width;
                    i += 2;
                    continue;
                }
                throw new RuntimeException(String.format("(_findStringWidth) Can't determine length of string '%s'", str));
            }
            ++i;
            ++width;
        }
        return width;
    }

    static String getHeader(String format, StructureType id, int nFrames, int nFeatures, boolean comments) {
        int width = IOUtils.findStringWidth(format);
        String s = "";
        assert (id == StructureType.FEATURE_LIST || id == StructureType.FEATURE_HISTORY || id == StructureType.FEATURE_TABLE);
        if (comments) {
            s = s + "Feel free to place comments here.\n\n\n";
            s = s + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
            s = s + warning_line;
            s = s + "\n";
        }
        s = s + "------------------------------\n";
        switch (id) {
            case FEATURE_LIST: {
                s = s + "KLT Feature List\n";
                break;
            }
            case FEATURE_HISTORY: {
                s = s + "KLT Feature History\n";
                break;
            }
            case FEATURE_TABLE: {
                s = s + "KLT Feature Table\n";
            }
        }
        s = s + "------------------------------\n\n";
        switch (id) {
            case FEATURE_LIST: {
                s = s + String.format("nFeatures = %d\n\n", nFeatures);
                break;
            }
            case FEATURE_HISTORY: {
                s = s + String.format("nFrames = %d\n\n", nFrames);
                break;
            }
            case FEATURE_TABLE: {
                s = s + String.format("nFrames = %d, nFeatures = %d\n\n", nFrames, nFeatures);
            }
        }
        switch (id) {
            case FEATURE_LIST: {
                s = s + "feature | (x,y)=val\n";
                s = s + "--------+-";
                s = s + IOUtils.getNhyphens(width);
                s = s + "\n";
                break;
            }
            case FEATURE_HISTORY: {
                s = s + "frame | (x,y)=val\n";
                s = s + "------+-";
                s = s + IOUtils.getNhyphens(width);
                s = s + "\n";
                break;
            }
            case FEATURE_TABLE: {
                int i;
                s = s + "feature |          frame\n";
                s = s + "        |";
                for (i = 0; i < nFrames; ++i) {
                    s = s + IOUtils.getInteger(i, width);
                }
                s = s + "\n--------+-";
                for (i = 0; i < nFrames; ++i) {
                    s = s + IOUtils.getNhyphens(width);
                }
                s = s + "\n";
            }
        }
        return s;
    }

    static enum StructureType {
        FEATURE_LIST,
        FEATURE_HISTORY,
        FEATURE_TABLE;

    }
}

