/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.transform;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.combiner.AccumulatingImageCombiner;
import org.openimaj.image.processing.transform.FProjectionProcessor;
import org.openimaj.image.processing.transform.MBFProjectionProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

public class ProjectionProcessor<Q, T extends Image<Q, T>>
implements AccumulatingImageCombiner<T, T> {
    protected int minc = 0;
    protected int minr = 0;
    protected int maxc = 0;
    protected int maxr = 0;
    protected boolean unset = true;
    protected List<Matrix> transforms;
    protected List<Matrix> transformsInverted;
    protected List<T> images;
    protected List<Shape> projectedShapes;
    protected List<Rectangle> projectedRectangles;
    protected Matrix currentMatrix = new Matrix((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});

    public ProjectionProcessor() {
        this.transforms = new ArrayList<Matrix>();
        this.transformsInverted = new ArrayList<Matrix>();
        this.images = new ArrayList<T>();
        this.projectedShapes = new ArrayList<Shape>();
        this.projectedRectangles = new ArrayList<Rectangle>();
    }

    public void setMatrix(Matrix matrix) {
        if (matrix.getRowDimension() == 2) {
            int c = matrix.getColumnDimension() - 1;
            this.currentMatrix = new Matrix(3, 3);
            this.currentMatrix.setMatrix(0, 1, 0, c, matrix);
            this.currentMatrix.set(2, 2, 1.0);
        } else {
            this.currentMatrix = matrix;
        }
    }

    public void accumulate(T image) {
        Rectangle actualBounds = image.getBounds();
        Shape transformedActualBounds = actualBounds.transform(this.currentMatrix);
        double tminX = transformedActualBounds.minX();
        double tmaxX = transformedActualBounds.maxX();
        double tminY = transformedActualBounds.minY();
        double tmaxY = transformedActualBounds.maxY();
        if (this.unset) {
            this.minc = (int)Math.floor(tminX);
            this.minr = (int)Math.floor(tminY);
            this.maxc = (int)Math.floor(tmaxX);
            this.maxr = (int)Math.floor(tmaxY);
            this.unset = false;
        } else {
            if (tminX < (double)this.minc) {
                this.minc = (int)Math.floor(tminX);
            }
            if (tmaxX > (double)this.maxc) {
                this.maxc = (int)Math.floor(tmaxX);
            }
            if (tminY < (double)this.minr) {
                this.minr = (int)Math.floor(tminY);
            }
            if (tmaxY > (double)this.maxr) {
                this.maxr = (int)Math.floor(tmaxY);
            }
        }
        float padding = 1.0f;
        Rectangle expandedBounds = new Rectangle(actualBounds.x - 1.0f, actualBounds.y - 1.0f, actualBounds.width + 2.0f, actualBounds.height + 2.0f);
        Shape transformedExpandedBounds = expandedBounds.transform(this.currentMatrix);
        Matrix minv = null;
        Matrix m = null;
        try {
            m = this.currentMatrix.copy();
            minv = this.currentMatrix.copy().inverse();
        }
        catch (Throwable e) {
            return;
        }
        this.images.add(image);
        this.transforms.add(m);
        this.transformsInverted.add(minv);
        this.projectedShapes.add(transformedExpandedBounds);
        this.projectedRectangles.add(transformedExpandedBounds.calculateRegularBoundingBox());
    }

    public T performProjection() {
        return this.performProjection(false, ((Image)this.images.get(0)).newInstance(1, 1).getPixel(0, 0));
    }

    public T performProjection(Q backgroundColour) {
        int projectionMinC = this.minc;
        int projectionMaxC = this.maxc;
        int projectionMinR = this.minr;
        int projectionMaxR = this.maxr;
        return this.performProjection(projectionMinC, projectionMaxC, projectionMinR, projectionMaxR, backgroundColour);
    }

    public T performProjection(boolean keepOriginalWindow, Q backgroundColour) {
        int projectionMinC = this.minc;
        int projectionMaxC = this.maxc;
        int projectionMinR = this.minr;
        int projectionMaxR = this.maxr;
        if (keepOriginalWindow) {
            projectionMinC = 0;
            projectionMinR = 0;
            projectionMaxR = ((Image)this.images.get(0)).getRows();
            projectionMaxC = ((Image)this.images.get(0)).getCols();
        }
        return this.performProjection(projectionMinC, projectionMaxC, projectionMinR, projectionMaxR, backgroundColour);
    }

    public T performProjection(int windowMinC, int windowMaxC, int windowMinR, int windowMaxR) {
        return this.performProjection(windowMinC, windowMaxC, windowMinR, windowMaxR, ((Image)this.images.get(0)).newInstance(1, 1).getPixel(0, 0));
    }

    public T performProjection(int windowMinC, int windowMaxC, int windowMinR, int windowMaxR, Q backgroundColour) {
        Image output = null;
        output = ((Image)this.images.get(0)).newInstance(windowMaxC - windowMinC, windowMaxR - windowMinR);
        if (backgroundColour != null) {
            output.fill(backgroundColour);
        }
        Shape[][] projectRectangleShapes = this.getCurrentShapes();
        for (int y = 0; y < output.getHeight(); ++y) {
            for (int x = 0; x < output.getWidth(); ++x) {
                Point2dImpl realPoint = new Point2dImpl((float)(windowMinC + x), (float)(windowMinR + y));
                int i = 0;
                for (int shapeIndex = 0; shapeIndex < this.projectedShapes.size(); ++shapeIndex) {
                    if (backgroundColour == null || this.isInside(shapeIndex, projectRectangleShapes, (Point2d)realPoint)) {
                        double[][] transform = this.transformsInverted.get(i).getArray();
                        float xt = (float)transform[0][0] * realPoint.getX() + (float)transform[0][1] * realPoint.getY() + (float)transform[0][2];
                        float yt = (float)transform[1][0] * realPoint.getX() + (float)transform[1][1] * realPoint.getY() + (float)transform[1][2];
                        float zt = (float)transform[2][0] * realPoint.getX() + (float)transform[2][1] * realPoint.getY() + (float)transform[2][2];
                        xt /= zt;
                        yt /= zt;
                        Image im = (Image)this.images.get(i);
                        if (backgroundColour != null) {
                            output.setPixel(x, y, im.getPixelInterp((double)xt, (double)yt, backgroundColour));
                        } else {
                            output.setPixel(x, y, im.getPixelInterp((double)xt, (double)yt));
                        }
                    }
                    ++i;
                }
            }
        }
        return (T)output;
    }

    protected Shape[][] getCurrentShapes() {
        Shape[][] currentShapes = new Shape[this.projectedShapes.size()][2];
        for (int i = 0; i < this.projectedShapes.size(); ++i) {
            currentShapes[i][0] = (Shape)this.projectedRectangles.get(i);
            currentShapes[i][1] = this.projectedShapes.get(i);
        }
        return currentShapes;
    }

    protected boolean isInside(int shapeIndex, Shape[][] projectRectangleShapes, Point2d realPoint) {
        return projectRectangleShapes[shapeIndex][0].isInside(realPoint) && projectRectangleShapes[shapeIndex][1].isInside(realPoint);
    }

    public T performProjection(int windowMinC, int windowMinR, T output) {
        for (int y = 0; y < output.getHeight(); ++y) {
            for (int x = 0; x < output.getWidth(); ++x) {
                Point2dImpl realPoint = new Point2dImpl((float)(windowMinC + x), (float)(windowMinR + y));
                int i = 0;
                for (Shape s : this.projectedShapes) {
                    if (s.calculateRegularBoundingBox().isInside((Point2d)realPoint) && s.isInside((Point2d)realPoint)) {
                        double[][] transform = this.transformsInverted.get(i).getArray();
                        float xt = (float)transform[0][0] * realPoint.getX() + (float)transform[0][1] * realPoint.getY() + (float)transform[0][2];
                        float yt = (float)transform[1][0] * realPoint.getX() + (float)transform[1][1] * realPoint.getY() + (float)transform[1][2];
                        float zt = (float)transform[2][0] * realPoint.getX() + (float)transform[2][1] * realPoint.getY() + (float)transform[2][2];
                        Image im = (Image)this.images.get(i);
                        output.setPixel(x, y, im.getPixelInterp((double)(xt /= zt), (double)(yt /= zt), output.getPixel(x, y)));
                    }
                    ++i;
                }
            }
        }
        return output;
    }

    public T performBlendedProjection(int windowMinC, int windowMaxC, int windowMinR, int windowMaxR, Q backgroundColour) {
        Image output = null;
        output = ((Image)this.images.get(0)).newInstance(windowMaxC - windowMinC, windowMaxR - windowMinR);
        HashMap<Integer, Boolean> setMap = new HashMap<Integer, Boolean>();
        Image blendingPallet = output.newInstance(2, 1);
        for (int y = 0; y < output.getHeight(); ++y) {
            for (int x = 0; x < output.getWidth(); ++x) {
                Point2dImpl realPoint = new Point2dImpl((float)(windowMinC + x), (float)(windowMinR + y));
                int i = 0;
                for (Shape s : this.projectedShapes) {
                    if (s.isInside((Point2d)realPoint)) {
                        double[][] transform = this.transformsInverted.get(i).getArray();
                        float xt = (float)transform[0][0] * realPoint.getX() + (float)transform[0][1] * realPoint.getY() + (float)transform[0][2];
                        float yt = (float)transform[1][0] * realPoint.getX() + (float)transform[1][1] * realPoint.getY() + (float)transform[1][2];
                        float zt = (float)transform[2][0] * realPoint.getX() + (float)transform[2][1] * realPoint.getY() + (float)transform[2][2];
                        Object toSet = null;
                        toSet = backgroundColour != null ? ((Image)this.images.get(i)).getPixelInterp((double)xt, (double)yt, backgroundColour) : (setMap.get(y * output.getWidth() + x) != null ? ((Image)this.images.get(i)).getPixelInterp((double)xt, (double)yt, output.getPixelInterp((double)x, (double)y)) : ((Image)this.images.get(i)).getPixelInterp((double)(xt /= zt), (double)(yt /= zt)));
                        if (setMap.get(y * output.getWidth() + x) != null) {
                            blendingPallet.setPixel(1, 0, toSet);
                            blendingPallet.setPixel(0, 0, output.getPixel(x, y));
                            toSet = blendingPallet.getPixelInterp(0.1, 0.5);
                        }
                        setMap.put(y * output.getWidth() + x, true);
                        output.setPixel(x, y, toSet);
                    }
                    ++i;
                }
            }
        }
        return (T)output;
    }

    public Matrix getMatrix() {
        return this.currentMatrix;
    }

    public static <Q, T extends Image<Q, T>> T project(T image, Matrix matrix) {
        if (image instanceof FImage) {
            FProjectionProcessor proc = new FProjectionProcessor();
            proc.setMatrix(matrix);
            ((FImage)image).accumulateWith((AccumulatingImageCombiner)proc);
            return proc.performProjection();
        }
        if (image instanceof MBFImage) {
            MBFProjectionProcessor proc = new MBFProjectionProcessor();
            proc.setMatrix(matrix);
            ((MBFImage)image).accumulateWith((AccumulatingImageCombiner)proc);
            return proc.performProjection();
        }
        ProjectionProcessor<Q, T> proc = new ProjectionProcessor<Q, T>();
        proc.setMatrix(matrix);
        image.accumulateWith(proc);
        return proc.performProjection();
    }

    public static <Q, T extends Image<Q, T>> T project(T image, Matrix matrix, Q backgroundColour) {
        ProjectionProcessor<Q, T> proc = new ProjectionProcessor<Q, T>();
        proc.setMatrix(matrix);
        image.accumulateWith(proc);
        return proc.performProjection(backgroundColour);
    }

    public T combine() {
        return this.performProjection();
    }
}

