/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.transform;

import Jama.Matrix;
import java.util.HashMap;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.transform.ProjectionProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Shape;

public class FProjectionProcessor
extends ProjectionProcessor<Float, FImage> {
    @Override
    public FImage performProjection(int windowMinC, int windowMaxC, int windowMinR, int windowMaxR, Float backgroundColour) {
        FImage output = null;
        output = new FImage(windowMaxC - windowMinC, windowMaxR - windowMinR);
        if (backgroundColour != null) {
            output.fill(backgroundColour);
        }
        Shape[][] shapeRects = this.getCurrentShapes();
        for (int y = 0; y < output.getHeight(); ++y) {
            for (int x = 0; x < output.getWidth(); ++x) {
                Point2dImpl realPoint = new Point2dImpl((float)(windowMinC + x), (float)(windowMinR + y));
                int i = 0;
                for (int j = 0; j < shapeRects.length; ++j) {
                    if (backgroundColour == null || this.isInside(j, shapeRects, (Point2d)realPoint)) {
                        double[][] transform = ((Matrix)this.transformsInverted.get(i)).getArray();
                        float xt = (float)transform[0][0] * realPoint.getX() + (float)transform[0][1] * realPoint.getY() + (float)transform[0][2];
                        float yt = (float)transform[1][0] * realPoint.getX() + (float)transform[1][1] * realPoint.getY() + (float)transform[1][2];
                        float zt = (float)transform[2][0] * realPoint.getX() + (float)transform[2][1] * realPoint.getY() + (float)transform[2][2];
                        FImage im = (FImage)this.images.get(i);
                        output.pixels[y][x] = backgroundColour != null ? im.getPixelInterp((double)xt, (double)yt, backgroundColour).floatValue() : im.getPixelInterp((double)(xt /= zt), (double)(yt /= zt)).floatValue();
                    }
                    ++i;
                }
            }
        }
        return output;
    }

    @Override
    public FImage performBlendedProjection(int windowMinC, int windowMaxC, int windowMinR, int windowMaxR, Float backgroundColour) {
        FImage output = null;
        output = new FImage(windowMaxC - windowMinC, windowMaxR - windowMinR);
        HashMap<Integer, Boolean> setMap = new HashMap<Integer, Boolean>();
        FImage blendingPallet = output.newInstance(2, 1);
        for (int y = 0; y < output.getHeight(); ++y) {
            for (int x = 0; x < output.getWidth(); ++x) {
                Point2dImpl realPoint = new Point2dImpl((float)(windowMinC + x), (float)(windowMinR + y));
                int i = 0;
                for (Shape s : this.projectedShapes) {
                    if (s.isInside((Point2d)realPoint)) {
                        double[][] transform = ((Matrix)this.transformsInverted.get(i)).getArray();
                        float xt = (float)transform[0][0] * realPoint.getX() + (float)transform[0][1] * realPoint.getY() + (float)transform[0][2];
                        float yt = (float)transform[1][0] * realPoint.getX() + (float)transform[1][1] * realPoint.getY() + (float)transform[1][2];
                        float zt = (float)transform[2][0] * realPoint.getX() + (float)transform[2][1] * realPoint.getY() + (float)transform[2][2];
                        Float toSet = null;
                        toSet = backgroundColour != null ? ((FImage)this.images.get(i)).getPixelInterp((double)xt, (double)yt, backgroundColour) : (setMap.get(y * output.getWidth() + x) != null ? ((FImage)this.images.get(i)).getPixelInterp((double)xt, (double)yt, output.getPixelInterp((double)x, (double)y)) : ((FImage)this.images.get(i)).getPixelInterp((double)(xt /= zt), (double)(yt /= zt)));
                        if (setMap.get(y * output.getWidth() + x) != null) {
                            blendingPallet.pixels[0][1] = toSet.floatValue();
                            blendingPallet.pixels[0][0] = output.getPixel(x, y).floatValue();
                            toSet = blendingPallet.getPixelInterp(0.1, 0.5);
                        }
                        setMap.put(y * output.getWidth() + x, true);
                        output.pixels[y][x] = toSet.floatValue();
                    }
                    ++i;
                }
            }
        }
        return output;
    }
}

