/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.edges;

import gnu.trove.list.array.TFloatArrayList;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandImageProcessor;

@Reference(author={"S. M. Smith"}, title="A new class of corner finder", type=ReferenceType.Article, url="http://users.fmrib.ox.ac.uk/~steve/susan/susan/node4.html", year="1992", booktitle="Proc. 3rd British Machine Vision Conference", pages={"139-148"})
public class SUSANEdgeDetector
implements SinglebandImageProcessor<Float, FImage> {
    private SUSANDetector susan = SUSANDetector.SIMPLE;

    public SUSANEdgeDetector() {
        this.susan = SUSANDetector.SIMPLE;
    }

    public SUSANEdgeDetector(SUSANDetector s, double threshold, double nmax) {
        this.susan = s;
        this.susan.threshold = threshold;
        this.susan.nmax = nmax;
    }

    public SUSANEdgeDetector(SUSANDetector s, double threshold, double nmax, double radius) {
        this.susan = s;
        this.susan.threshold = threshold;
        this.susan.nmax = nmax;
        this.susan.radius = radius;
    }

    public void processImage(FImage image) {
        image.internalAssign(this.susan.process(image));
    }

    public static FImage simpleSusan(FImage img, double thresh, double nmax) {
        FImage area = new FImage(img.getWidth(), img.getHeight());
        double globalThresh = 3.0 * nmax / 4.0;
        for (int y = 1; y < img.getHeight() - 1; ++y) {
            for (int x = 1; x < img.getWidth() - 1; ++x) {
                double a = 0.0;
                for (int x1 = x - 1; x1 < x + 2; ++x1) {
                    for (int y1 = y - 1; y1 < y + 2; ++y1) {
                        if (!((double)Math.abs(img.getPixel(x1, y1).floatValue() - img.getPixel(x, y).floatValue()) < thresh)) continue;
                        a += 1.0;
                    }
                }
                if (!(a < globalThresh)) continue;
                area.setPixel(x, y, Float.valueOf((float)(globalThresh - a)));
            }
        }
        return area;
    }

    public static FImage smoothSusan(FImage img, double thresh, double nmax) {
        FImage area = new FImage(img.getWidth(), img.getHeight());
        double globalThresh = 3.0 * nmax / 4.0;
        for (int y = 1; y < img.getHeight() - 1; ++y) {
            for (int x = 1; x < img.getWidth() - 1; ++x) {
                double a = 0.0;
                for (int x1 = x - 1; x1 < x + 2; ++x1) {
                    for (int y1 = y - 1; y1 < y + 2; ++y1) {
                        a += Math.exp(-Math.pow((double)Math.abs(img.getPixel(x1, y1).floatValue() - img.getPixel(x, y).floatValue()) / thresh, 6.0));
                    }
                }
                if (!(a < globalThresh)) continue;
                area.setPixel(x, y, Float.valueOf((float)(globalThresh - a)));
            }
        }
        return area;
    }

    public static FImage smoothCircularSusan(FImage img, double thresh, double nmax, double radius) {
        int r;
        FImage area = new FImage(img.getWidth(), img.getHeight());
        double globalThresh = 3.0 * nmax / 4.0;
        for (int y = r = (int)Math.ceil(radius); y < img.getHeight() - r; ++y) {
            for (int x = r; x < img.getWidth() - r; ++x) {
                float[] pixelValues = SUSANEdgeDetector.getPixelsInCircle(x, y, radius, img);
                double a = 0.0;
                for (float f : pixelValues) {
                    a += Math.exp(-Math.pow((double)Math.abs(f - img.getPixel(x, y).floatValue()) / thresh, 6.0));
                }
                if (!(a < globalThresh)) continue;
                area.setPixel(x, y, Float.valueOf((float)(globalThresh - a)));
            }
        }
        return area;
    }

    private static float[] getPixelsInCircle(int cx, int cy, double r, FImage img) {
        TFloatArrayList f = new TFloatArrayList();
        for (int i = (int)Math.ceil((double)cx - r); i < (int)Math.ceil((double)cx + r); ++i) {
            double ri = Math.sqrt(r * r - (double)((i - cx) * (i - cx)));
            for (int j = (int)Math.ceil((double)cy - ri); j < (int)Math.ceil((double)cy + ri); ++j) {
                f.add(img.getPixel(i, j).floatValue());
            }
        }
        return f.toArray();
    }

    private static enum SUSANDetector {
        SIMPLE{

            @Override
            public FImage process(FImage img) {
                return SUSANEdgeDetector.simpleSusan(img, this.threshold, this.nmax);
            }
        }
        ,
        SMOOTH{

            @Override
            public FImage process(FImage img) {
                return SUSANEdgeDetector.smoothSusan(img, this.threshold, this.nmax);
            }
        }
        ,
        CIRCULAR{

            @Override
            public FImage process(FImage img) {
                return SUSANEdgeDetector.smoothCircularSusan(img, this.threshold, this.nmax, this.radius);
            }
        };

        protected double threshold = 0.08;
        protected double nmax = 9.0;
        protected double radius = 3.4;

        public abstract FImage process(FImage var1);
    }
}

