/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.openimaj.image.FImage;
import org.openimaj.util.array.ArrayUtils;

public class GaborFilters {
    private GaborFilters() {
    }

    public static FImage[] createGaborJets(int width, int height, int ... orientationsPerScale) {
        int nscales = orientationsPerScale.length;
        int nfilters = (int)ArrayUtils.sumValues((int[])orientationsPerScale);
        FImage[] filters = new FImage[nfilters];
        double[][] param = new double[nfilters][];
        int l = 0;
        for (int i = 0; i < nscales; ++i) {
            for (int j = 0; j < orientationsPerScale[i]; ++j) {
                param[l++] = new double[]{0.35, 0.3 / Math.pow(1.85, i), 16.0 * (double)orientationsPerScale[i] * (double)orientationsPerScale[i] / 1024.0, Math.PI / (double)orientationsPerScale[i] * (double)j};
            }
        }
        double[][] freq = new double[height][width];
        double[][] phase = new double[height][width];
        float hw = (float)width / 2.0f;
        float hh = (float)height / 2.0f;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float fx = (float)x - hw;
                float fy = (float)y - hh;
                freq[y][x] = Math.sqrt(fx * fx + fy * fy);
                phase[y][x] = Math.atan2(fy, fx);
            }
        }
        for (int i = 0; i < nfilters; ++i) {
            filters[i] = new FImage(width * 2, height);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double tr = phase[y][x] + param[i][3];
                    if (tr > Math.PI) {
                        tr -= Math.PI * 2;
                    } else if (tr < -Math.PI) {
                        tr += Math.PI * 2;
                    }
                    filters[i].pixels[y][x * 2] = (float)Math.exp(-10.0 * param[i][0] * (freq[y][x] / (double)width / param[i][1] - 1.0) * (freq[y][x] / (double)width / param[i][1] - 1.0) - 2.0 * param[i][2] * Math.PI * tr * tr);
                }
            }
        }
        return filters;
    }
}

