/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.algorithm.FourierTransform;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class FourierCorrelation
implements SinglebandImageProcessor<Float, FImage> {
    public FImage template;

    public FourierCorrelation(FImage template) {
        this.template = template;
    }

    public void processImage(FImage image) {
        FourierCorrelation.correlate(image, this.template, true);
    }

    public static FImage correlate(FImage image, FImage template, boolean inplace) {
        int cols = image.getCols();
        int rows = image.getRows();
        FloatFFT_2D fft = new FloatFFT_2D(rows, cols);
        float[][] preparedImage = FourierTransform.prepareData(image.pixels, rows, cols, false);
        fft.complexForward(preparedImage);
        float[][] preparedKernel = FourierTransform.prepareData(template.pixels, rows, cols, false);
        fft.complexForward(preparedKernel);
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                float reImage = preparedImage[y][x * 2];
                float imImage = preparedImage[y][1 + x * 2];
                float reKernel = preparedKernel[y][x * 2];
                float imKernelConj = -1.0f * preparedKernel[y][1 + x * 2];
                float re = reImage * reKernel - imImage * imKernelConj;
                float im = reImage * imKernelConj + imImage * reKernel;
                preparedImage[y][x * 2] = re;
                preparedImage[y][1 + x * 2] = im;
            }
        }
        fft.complexInverse(preparedImage, true);
        FImage out = image;
        if (!inplace) {
            out = new FImage(cols, rows);
        }
        FourierTransform.unprepareData(preparedImage, out, false);
        return out;
    }
}

