/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import java.util.LinkedHashSet;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.Pixel;

public class FloodFill<I extends Image<?, I>>
implements ImageAnalyser<I> {
    FImage flooded;
    Pixel startPixel;
    float threshold;

    public FloodFill(int x, int y, float threshold) {
        this.startPixel = new Pixel(x, y);
        this.threshold = threshold;
    }

    public FloodFill(Pixel startPixel, float threshold) {
        this.startPixel = startPixel;
        this.threshold = threshold;
    }

    public void analyseImage(I image) {
        this.flooded = FloodFill.floodFill(image, this.startPixel, this.threshold);
    }

    public FImage getFlooded() {
        return this.flooded;
    }

    protected static <T> boolean accept(Image<T, ?> image, Pixel n, T initial, float threshold) {
        if (image instanceof FImage) {
            return Math.abs(((Float)initial).floatValue() - ((Float)image.getPixel(n.x, n.y)).floatValue()) < threshold;
        }
        if (image instanceof MBFImage) {
            Float[] finit = (Float[])initial;
            Float[] fpix = (Float[])image.getPixel(n.x, n.y);
            float accum = 0.0f;
            for (int i = 0; i < finit.length; ++i) {
                accum += (finit[i].floatValue() - fpix[i].floatValue()) * (finit[i].floatValue() - fpix[i].floatValue());
            }
            return Math.sqrt(accum) < (double)threshold;
        }
        throw new RuntimeException("unsupported image type");
    }

    public static <T> FImage floodFill(Image<T, ?> image, int startx, int starty, float threshold) {
        return FloodFill.floodFill(image, new Pixel(startx, starty), threshold);
    }

    public static <T> FImage floodFill(Image<T, ?> image, Pixel start, float threshold) {
        FImage output = new FImage(image.getWidth(), image.getHeight());
        LinkedHashSet<Pixel> queue = new LinkedHashSet<Pixel>();
        Object initial = image.getPixel(start.x, start.y);
        queue.add(start);
        while (queue.size() > 0) {
            Pixel n = (Pixel)queue.iterator().next();
            queue.remove(n);
            if (!FloodFill.accept(image, n, initial, threshold)) continue;
            int e = n.x;
            for (int w = n.x; w > 0 && FloodFill.accept(image, new Pixel(w - 1, n.y), initial, threshold); --w) {
            }
            while (e < image.getWidth() - 1 && FloodFill.accept(image, new Pixel(e + 1, n.y), initial, threshold)) {
                ++e;
            }
            for (int i = w; i <= e; ++i) {
                output.pixels[n.y][i] = 1.0f;
                int north = n.y - 1;
                int south = n.y + 1;
                if (north >= 0 && FloodFill.accept(image, new Pixel(i, north), initial, threshold) && output.pixels[north][i] != 1.0f) {
                    queue.add(new Pixel(i, north));
                }
                if (south >= image.getHeight() || !FloodFill.accept(image, new Pixel(i, south), initial, threshold) || output.pixels[south][i] == 1.0f) continue;
                queue.add(new Pixel(i, south));
            }
        }
        return output;
    }
}

