/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest;

import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.feature.local.interest.AbstractStructureTensorIPD;
import org.openimaj.image.processing.convolution.FImageConvolveSeparable;
import org.openimaj.image.processor.PixelProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class QuadratureIPD
extends AbstractStructureTensorIPD {
    public QuadratureIPD(float detectionScale, float integrationScale) {
        super(detectionScale, integrationScale);
    }

    @Override
    public FImage createInterestPointMap() {
        float s2 = this.detectionScale * this.detectionScale;
        int filtsize = Math.max(3, Math.round(5.0f * this.detectionScale));
        float[] g = new float[2 * filtsize + 1];
        float[] f1 = new float[2 * filtsize + 1];
        float[] f2 = new float[2 * filtsize + 1];
        float[] mf2 = new float[2 * filtsize + 1];
        float[] f3 = new float[2 * filtsize + 1];
        float[] mf3 = new float[2 * filtsize + 1];
        float[] f4 = new float[2 * filtsize + 1];
        int i = 0;
        int t = -filtsize;
        while (t <= filtsize) {
            g[i] = (float)(Math.exp((float)(-(t * t)) / (2.0f * s2)) / Math.sqrt(Math.PI * 2 * (double)s2));
            f1[i] = g[i] * ((float)(t * t) / s2 - 1.0f) / s2;
            f2[i] = g[i] * (float)t / s2;
            mf2[i] = -f2[i];
            f3[i] = (float)((double)g[i] * (3.0 - 0.6666666666666666 * (double)t * (double)t / (double)s2) * (double)t / Math.sqrt(Math.PI) / Math.sqrt(s2) / (double)s2);
            mf3[i] = f3[i];
            f4[i] = (float)((double)g[i] * (1.0 - 0.6666666666666666 * (double)t * (double)t / (double)s2) / Math.sqrt(Math.PI) / Math.sqrt(s2));
            ++t;
            ++i;
        }
        FImage e1 = (FImage)this.originalImage.process((SinglebandImageProcessor)new FImageConvolveSeparable(f3, g));
        FImage e2 = (FImage)this.originalImage.process((SinglebandImageProcessor)new FImageConvolveSeparable(f4, mf2));
        FImage e3 = (FImage)this.originalImage.process((SinglebandImageProcessor)new FImageConvolveSeparable(f2, f4));
        FImage e4 = (FImage)this.originalImage.process((SinglebandImageProcessor)new FImageConvolveSeparable(g, mf3));
        FImage gx = e1.addInplace(e3).multiplyInplace(0.75f);
        FImage gy = e2.addInplace(e4).multiplyInplace(0.75f);
        FImage hxx = (FImage)this.originalImage.process((SinglebandImageProcessor)new FImageConvolveSeparable(f1, g));
        FImage hxy = (FImage)this.originalImage.process((SinglebandImageProcessor)new FImageConvolveSeparable(f2, mf2));
        FImage hyy = (FImage)this.originalImage.process((SinglebandImageProcessor)new FImageConvolveSeparable(g, f1));
        FImage b11 = ((FImage)gx.multiply((Image)gx)).add(hxx.multiplyInplace(hxx));
        FImage b12 = ((FImage)gx.multiply((Image)gy)).add(hxy.multiplyInplace(hxy));
        FImage b22 = ((FImage)gy.multiply((Image)gy)).add(hyy.multiplyInplace(hyy));
        FImage ebound = b11.add(b22);
        FImage b11b22 = b11.subtractInplace(b22);
        FImage eedge = b11b22.multiplyInplace(b11b22).add(b12.multiplyInplace(b12).multiplyInplace(4.0f)).processInplace((PixelProcessor)new PixelProcessor<Float>(){

            public Float processPixel(Float pixel) {
                return Float.valueOf((float)Math.sqrt(pixel.floatValue()));
            }
        });
        FImage cimg = ebound.subtractInplace(eedge).processInplace((PixelProcessor)new PixelProcessor<Float>(){

            public Float processPixel(Float pixel) {
                return Float.valueOf(-pixel.floatValue());
            }
        });
        return cimg;
    }

    @Override
    public QuadratureIPD clone() {
        return (QuadratureIPD)super.clone();
    }
}

