/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.engine.asift;

import java.util.Map;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.local.affine.AffineSimulationExtractor;
import org.openimaj.image.feature.local.affine.AffineSimulationKeypoint;
import org.openimaj.image.feature.local.affine.BasicASIFT;
import org.openimaj.image.feature.local.engine.DoGSIFTEngineOptions;
import org.openimaj.image.feature.local.engine.Engine;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.image.processing.transform.AffineParams;

@Reference(type=ReferenceType.Article, author={"Morel, Jean-Michel", "Yu, Guoshen"}, title="{ASIFT: A New Framework for Fully Affine Invariant Image Comparison}", year="2009", journal="SIAM J. Img. Sci.", publisher="Society for Industrial and Applied Mathematics")
public class ASIFTEngine
implements Engine<AffineSimulationKeypoint, FImage> {
    protected AffineSimulationExtractor<LocalFeatureList<Keypoint>, Keypoint, FImage, Float> asift;
    protected int nTilts = 5;

    public ASIFTEngine() {
        this(false);
    }

    public ASIFTEngine(boolean hires) {
        this.asift = new BasicASIFT(hires);
    }

    public ASIFTEngine(boolean hires, int nTilts) {
        this.asift = new BasicASIFT(hires);
        this.nTilts = nTilts;
    }

    public ASIFTEngine(DoGSIFTEngineOptions<FImage> opts) {
        this.asift = new BasicASIFT(opts);
    }

    public ASIFTEngine(DoGSIFTEngineOptions<FImage> opts, int nTilts) {
        this.asift = new BasicASIFT(opts);
        this.nTilts = nTilts;
    }

    public LocalFeatureList<Keypoint> findKeypoints(FImage image) {
        this.asift.detectFeatures(image, this.nTilts);
        return this.asift.getFeatures();
    }

    public LocalFeatureList<Keypoint> findKeypoints(FImage image, AffineParams params) {
        return this.asift.detectFeatures(image, params);
    }

    public Map<AffineParams, LocalFeatureList<Keypoint>> findKeypointsMapped(FImage image) {
        this.asift.detectFeatures(image, this.nTilts);
        return this.asift.getKeypointsMap();
    }

    @Override
    public LocalFeatureList<AffineSimulationKeypoint> findFeatures(FImage image) {
        this.asift.detectFeatures(image, this.nTilts);
        Map<AffineParams, LocalFeatureList<Keypoint>> keypointMap = this.asift.getKeypointsMap();
        MemoryLocalFeatureList affineSimulationList = new MemoryLocalFeatureList();
        for (AffineParams params : this.asift.simulationOrder) {
            for (Keypoint k : keypointMap.get(params)) {
                affineSimulationList.add((Object)new AffineSimulationKeypoint(k, params, this.asift.simulationOrder.indexOf(params)));
            }
        }
        return affineSimulationList;
    }
}

