/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.engine;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramid;
import org.openimaj.image.feature.local.descriptor.gradient.SIFTFeatureProvider;
import org.openimaj.image.feature.local.detector.dog.collector.OctaveKeypointCollector;
import org.openimaj.image.feature.local.detector.dog.extractor.DominantOrientationExtractor;
import org.openimaj.image.feature.local.detector.dog.extractor.GradientFeatureExtractor;
import org.openimaj.image.feature.local.detector.dog.extractor.OrientationHistogramExtractor;
import org.openimaj.image.feature.local.detector.dog.pyramid.DoGOctaveExtremaFinder;
import org.openimaj.image.feature.local.detector.pyramid.BasicOctaveExtremaFinder;
import org.openimaj.image.feature.local.engine.DoGSIFTEngineOptions;
import org.openimaj.image.feature.local.engine.Engine;
import org.openimaj.image.feature.local.keypoints.Keypoint;

@References(references={@Reference(type=ReferenceType.Article, author={"David Lowe"}, title="Distinctive image features from scale-invariant keypoints", year="2004", journal="IJCV", pages={"91", "110"}, month="January", number="2", volume="60"), @Reference(type=ReferenceType.Inproceedings, author={"David Lowe"}, title="Object recognition from local scale-invariant features", year="1999", booktitle="Proc. of the International Conference on Computer Vision {ICCV}", pages={"1150", "1157"})})
public class DoGSIFTEngine
implements Engine<Keypoint, FImage> {
    DoGSIFTEngineOptions<FImage> options;

    public DoGSIFTEngine() {
        this(new DoGSIFTEngineOptions<FImage>());
    }

    public DoGSIFTEngine(DoGSIFTEngineOptions<FImage> options) {
        this.options = options;
    }

    @Override
    public LocalFeatureList<Keypoint> findFeatures(FImage image) {
        DoGOctaveExtremaFinder finder = new DoGOctaveExtremaFinder(new BasicOctaveExtremaFinder(this.options.magnitudeThreshold, this.options.eigenvalueRatio));
        OctaveKeypointCollector<FImage> collector = new OctaveKeypointCollector<FImage>(new GradientFeatureExtractor(new DominantOrientationExtractor(this.options.peakThreshold, new OrientationHistogramExtractor(this.options.numOriHistBins, this.options.scaling, this.options.smoothingIterations, this.options.samplingSize)), new SIFTFeatureProvider(this.options.numOriBins, this.options.numSpatialBins, this.options.valueThreshold, this.options.gaussianSigma), this.options.magnificationFactor * (float)this.options.numSpatialBins));
        finder.setOctaveInterestPointListener(collector);
        this.options.setOctaveProcessor(finder);
        GaussianPyramid pyr = new GaussianPyramid(this.options);
        pyr.process((Image)image);
        return collector.getFeatures();
    }

    public DoGSIFTEngineOptions<FImage> getOptions() {
        return this.options;
    }
}

