/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.pyramid;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.feature.local.detector.pyramid.AbstractOctaveExtremaFinder;

@References(references={@Reference(type=ReferenceType.Article, author={"David Lowe"}, title="Distinctive image features from scale-invariant keypoints", year="2004", journal="IJCV", pages={"91", "110"}, month="January", number="2", volume="60"), @Reference(type=ReferenceType.Inproceedings, author={"David Lowe"}, title="Object recognition from local scale-invariant features", year="1999", booktitle="Proc. of the International Conference on Computer Vision {ICCV}", pages={"1150", "1157"})})
public class BasicOctaveExtremaFinder
extends AbstractOctaveExtremaFinder<GaussianOctave<FImage>> {
    public static final float DEFAULT_MAGNITUDE_THRESHOLD = 0.04f;
    protected float magnitudeThreshold = 0.04f;
    protected float scales;
    protected float normMagnitudeScales;

    public BasicOctaveExtremaFinder() {
    }

    public BasicOctaveExtremaFinder(float magnitudeThreshold) {
        this(magnitudeThreshold, 10.0f);
    }

    public BasicOctaveExtremaFinder(float magnitudeThreshold, float eigenvalueRatio) {
        super(eigenvalueRatio);
        this.magnitudeThreshold = magnitudeThreshold;
    }

    @Override
    protected void beforeProcess(GaussianOctave<FImage> octave) {
        this.scales = ((GaussianPyramidOptions)octave.options).getScales();
        this.normMagnitudeScales = this.magnitudeThreshold / (float)((GaussianPyramidOptions)octave.options).getScales();
    }

    @Override
    protected boolean firstCheck(float val, int x, int y, int s, FImage[] dogs) {
        return Math.abs(dogs[s].pixels[y][x]) > this.normMagnitudeScales;
    }

    @Override
    protected void processExtrema(FImage[] dogs, int s, int x, int y, float octSize) {
        float octaveScale = ((GaussianPyramidOptions)((GaussianOctave)this.octave).options).getInitialSigma() * (float)Math.pow(2.0, (float)s / this.scales);
        if (this.listener != null) {
            this.listener.foundInterestPoint(this, x, y, octaveScale);
        }
    }
}

