/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.aggregate;

import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.FloatFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.image.feature.local.aggregate.VectorAggregator;
import org.openimaj.math.statistics.distribution.MixtureOfGaussians;
import org.openimaj.math.statistics.distribution.MultivariateGaussian;

@References(references={@Reference(type=ReferenceType.Inproceedings, author={"Perronnin, F.", "Dance, C."}, title="Fisher Kernels on Visual Vocabularies for Image Categorization", year="2007", booktitle="Computer Vision and Pattern Recognition, 2007. CVPR '07. IEEE Conference on", pages={"1", "8"}, customData={"keywords", "Gaussian processes;gradient methods;image classification;Fisher kernels;Gaussian mixture model;generative probability model;gradient vector;image categorization;pattern classification;visual vocabularies;Character generation;Feeds;Image databases;Kernel;Pattern classification;Power generation;Signal generators;Spatial databases;Visual databases;Vocabulary", "doi", "10.1109/CVPR.2007.383266", "ISSN", "1063-6919"}), @Reference(type=ReferenceType.Inproceedings, author={"Perronnin, Florent", "S'{a}nchez, Jorge", "Mensink, Thomas"}, title="Improving the Fisher Kernel for Large-scale Image Classification", year="2010", booktitle="Proceedings of the 11th European Conference on Computer Vision: Part IV", pages={"143", "", "156"}, url="http://dl.acm.org/citation.cfm?id=1888089.1888101", publisher="Springer-Verlag", series="ECCV'10", customData={"isbn", "3-642-15560-X, 978-3-642-15560-4", "location", "Heraklion, Crete, Greece", "numpages", "14", "acmid", "1888101", "address", "Berlin, Heidelberg"})})
public class FisherVector<T>
implements VectorAggregator<ArrayFeatureVector<T>, FloatFV> {
    private MixtureOfGaussians gmm;
    private boolean hellinger;
    private boolean l2normalise;

    public FisherVector(MixtureOfGaussians gmm, boolean hellinger, boolean l2normalise) {
        this.gmm = gmm;
        this.hellinger = hellinger;
        this.l2normalise = l2normalise;
    }

    public FisherVector(MixtureOfGaussians gmm) {
        this(gmm, false);
    }

    public FisherVector(MixtureOfGaussians gmm, boolean improved) {
        this(gmm, improved, improved);
    }

    @Override
    public FloatFV aggregate(List<? extends LocalFeature<?, ? extends ArrayFeatureVector<T>>> features) {
        if (features == null || features.size() <= 0) {
            return null;
        }
        int K = this.gmm.gaussians.length;
        int D = ((ArrayFeatureVector)features.get(0).getFeatureVector()).length();
        float[] vector = new float[2 * K * D];
        double[][] X = new double[features.size()][];
        for (int i = 0; i < X.length; ++i) {
            LocalFeature<?, ? extends ArrayFeatureVector<T>> f = features.get(i);
            X[i] = ((ArrayFeatureVector)f.getFeatureVector()).asDoubleVector();
        }
        double[][] posteriors = (double[][])this.gmm.scoreSamples((double[][])X).secondObject();
        for (int p = 0; p < X.length; ++p) {
            double[] xp = X[p];
            for (int k = 0; k < K; ++k) {
                double apk = posteriors[p][k];
                if (apk < 1.0E-6) continue;
                MultivariateGaussian gauss = this.gmm.gaussians[k];
                double[] mean = gauss.getMean().getArray()[0];
                for (int j = 0; j < D; ++j) {
                    double var = gauss.getCovariance(j, j);
                    double diff = (xp[j] - mean[j]) / Math.sqrt(var);
                    int n = k * 2 * D + j;
                    vector[n] = (float)((double)vector[n] + apk * diff);
                    int n2 = k * 2 * D + j + D;
                    vector[n2] = (float)((double)vector[n2] + apk * (diff * diff - 1.0));
                }
            }
        }
        for (int k = 0; k < K; ++k) {
            double wt1 = 1.0 / ((double)features.size() * Math.sqrt(this.gmm.weights[k]));
            double wt2 = 1.0 / ((double)features.size() * Math.sqrt(2.0 * this.gmm.weights[k]));
            for (int j = 0; j < D; ++j) {
                int n = k * 2 * D + j;
                vector[n] = (float)((double)vector[n] * wt1);
                int n3 = k * 2 * D + j + D;
                vector[n3] = (float)((double)vector[n3] * wt2);
            }
        }
        FloatFV out = new FloatFV(vector);
        if (this.hellinger) {
            for (int i = 0; i < ((float[])out.values).length; ++i) {
                ((float[])out.values)[i] = (float)(((float[])out.values)[i] > 0.0f ? Math.sqrt(((float[])out.values)[i]) : -1.0 * Math.sqrt(-1.0f * ((float[])out.values)[i]));
            }
        }
        if (this.l2normalise) {
            double sumsq = 0.0;
            for (int i = 0; i < ((float[])out.values).length; ++i) {
                sumsq += (double)(((float[])out.values)[i] * ((float[])out.values)[i]);
            }
            float norm = (float)(1.0 / Math.sqrt(sumsq));
            int i = 0;
            while (i < ((float[])out.values).length) {
                float[] fArray = (float[])out.values;
                int n = i++;
                fArray[n] = fArray[n] * norm;
            }
        }
        return out;
    }
}

