/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher.consistent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openimaj.feature.local.matcher.FastBasicKeypointMatcher;
import org.openimaj.feature.local.matcher.consistent.ModelFittingLocalFeatureMatcher;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.knn.CoordinateKDTree;
import org.openimaj.math.geometry.point.Coordinate;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.model.Model;
import org.openimaj.math.model.fit.RobustModelFitting;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class LocalConsistentKeypointMatcher<T extends Keypoint>
extends FastBasicKeypointMatcher<T>
implements ModelFittingLocalFeatureMatcher<T> {
    RobustModelFitting<Point2d, Point2d, ?> modelfit;
    List<Pair<T>> consistentMatches = new ArrayList<Pair<T>>();
    Model<Point2d, Point2d> model = null;
    CoordinateKDTree<T> tree;
    Keypoint minDim = new Keypoint();
    Keypoint maxDim = new Keypoint();

    public LocalConsistentKeypointMatcher(int threshold) {
        super(threshold);
    }

    @Override
    public List<Pair<T>> getMatches() {
        return this.consistentMatches;
    }

    public List<Pair<T>> getAllMatches() {
        return this.matches;
    }

    @Override
    public Model<Point2d, Point2d> getModel() {
        return this.model;
    }

    @Override
    public boolean findMatches(List<T> keys1) {
        Keypoint k;
        this.model = null;
        this.matches = new ArrayList();
        this.consistentMatches = new ArrayList<Pair<T>>();
        ArrayList<Pair> li_p2d = new ArrayList<Pair>();
        ArrayList klist1 = new ArrayList();
        this.tree.rangeSearch(klist1, (Coordinate)this.minDim, (Coordinate)this.maxDim);
        Keypoint initMatch = null;
        Iterator<T> i$ = keys1.iterator();
        while (i$.hasNext() && (initMatch = this.checkForMatch(k = (Keypoint)i$.next(), klist1)) == null) {
        }
        if (initMatch == null) {
            System.out.println("no match found!");
            return false;
        }
        Keypoint lbound = new Keypoint();
        Keypoint ubound = new Keypoint();
        lbound.x = initMatch.x - 100.0f;
        lbound.y = initMatch.y - 100.0f;
        lbound.scale = this.minDim.scale;
        ubound.x = initMatch.x + 100.0f;
        ubound.y = initMatch.y + 100.0f;
        ubound.scale = this.maxDim.scale;
        ArrayList klist = new ArrayList();
        this.tree.rangeSearch(klist, (Coordinate)lbound, (Coordinate)ubound);
        for (Keypoint k2 : keys1) {
            Keypoint match = this.checkForMatch(k2, klist);
            if (match == null) continue;
            li_p2d.add(new Pair((Object)k2, (Object)match));
            this.matches.add(new Pair((Object)k2, (Object)match));
            if (this.matches.size() < 10) continue;
            break;
        }
        if (this.matches.size() < this.modelfit.numItemsToEstimate()) {
            System.out.println("Not enough matches to check consistency!");
            return false;
        }
        if (this.modelfit.fitData(li_p2d)) {
            this.model = this.modelfit.getModel();
            Iterator<Object> i$2 = this.modelfit.getInliers().iterator();
            while (i$2.hasNext()) {
                IndependentPair p;
                IndependentPair op = p = (IndependentPair)i$2.next();
                this.consistentMatches.add((Pair)op);
            }
        }
        return true;
    }

    @Override
    public void setFittingModel(RobustModelFitting<Point2d, Point2d, ?> mf) {
        this.modelfit = mf;
    }

    @Override
    public void setModelFeatures(List<T> map) {
        try {
            this.tree = new CoordinateKDTree();
            for (Keypoint k : map) {
                this.tree.insert((Coordinate)k);
                if (k.x < this.minDim.x) {
                    this.minDim.x = k.x;
                }
                if (k.y < this.minDim.y) {
                    this.minDim.y = k.y;
                }
                if (k.scale < this.minDim.scale) {
                    this.minDim.scale = k.scale;
                }
                if (k.x > this.maxDim.x) {
                    this.maxDim.x = k.x;
                }
                if (k.y > this.maxDim.y) {
                    this.maxDim.y = k.y;
                }
                if (!(k.scale > this.maxDim.scale)) continue;
                this.maxDim.scale = k.scale;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

