/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.saliency;

import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.saliency.AchantaSaliency;
import org.openimaj.image.saliency.SaliencyMapGenerator;
import org.openimaj.image.segmentation.FelzenszwalbHuttenlocherSegmenter;

@Reference(type=ReferenceType.Inproceedings, author={"Che-Hua Yeh, Yuan-Chen Ho, Brian A. Barsky, Ming Ouhyoung"}, title="Personalized Photograph Ranking and Selection System", year="2010", booktitle="Proceedings of ACM Multimedia", pages={"211", "220"}, month="October", customData={"location", "Florence, Italy"})
public class YehSaliency
implements SaliencyMapGenerator<MBFImage> {
    AchantaSaliency saliencyGenerator;
    FelzenszwalbHuttenlocherSegmenter<MBFImage> segmenter;
    protected FImage map;
    protected TObjectFloatHashMap<ConnectedComponent> componentMap;

    public YehSaliency() {
        this.saliencyGenerator = new AchantaSaliency();
        this.segmenter = new FelzenszwalbHuttenlocherSegmenter();
    }

    public YehSaliency(float saliencySigma, float segmenterSigma, float k, int minSize) {
        this.saliencyGenerator = new AchantaSaliency(saliencySigma);
        this.segmenter = new FelzenszwalbHuttenlocherSegmenter(segmenterSigma, k, minSize);
    }

    public void analyseImage(MBFImage image) {
        List<ConnectedComponent> ccs = this.segmenter.segment(image);
        image.analyseWith((ImageAnalyser)this.saliencyGenerator);
        this.map = this.saliencyGenerator.getSaliencyMap();
        this.componentMap = new TObjectFloatHashMap();
        for (ConnectedComponent cc : ccs) {
            float mean = 0.0f;
            for (Pixel p : cc.pixels) {
                mean += this.map.pixels[p.y][p.x];
            }
            mean /= (float)cc.pixels.size();
            for (Pixel p : cc.pixels) {
                this.map.pixels[p.y][p.x] = mean;
            }
            this.componentMap.put((Object)cc, mean);
        }
    }

    @Override
    public FImage getSaliencyMap() {
        return this.map;
    }

    public TObjectFloatHashMap<ConnectedComponent> getSaliencyComponents() {
        return this.componentMap;
    }
}

