/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.asm.datasets;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.DataUtils;
import org.openimaj.experiment.annotations.DatasetDescription;
import org.openimaj.image.Image;
import org.openimaj.image.model.asm.datasets.ShapeModelDataset;
import org.openimaj.image.model.asm.datasets.ShapeModelDatasets;
import org.openimaj.io.InputStreamObjectReader;

@DatasetDescription(name="The IMM Face Database", description="A dataset consisting of 240 annotated monocular images of 40 different human faces. Points of correspondence are placed on each image so the dataset can be readily used for building statistical models of shape.", creator="Michael M. Nordstrom, Mads Larsen, Janusz Sierakowski, and Mikkel B. Stegmann", url="http://www2.imm.dtu.dk/~aam/datasets/datasets.html", downloadUrls={"http://datasets.openimaj.org/imm_face_db.zip"})
@Reference(type=ReferenceType.Article, author={"M. B. Stegmann", "B. K. Ersb{\\o}ll", "R. Larsen"}, title="{FAME} -- A Flexible Appearance Modelling Environment", year="2003", journal="IEEE Trans. on Medical Imaging", pages={"1319", "1331"}, number="10", publisher="IEEE", volume="22")
public class IMMFaceDatabase {
    private static final String DATA_ZIP = "imm_face_db.zip";
    private static final String DATA_DOWNLOAD_URL = "http://datasets.openimaj.org/imm_face_db.zip";

    public static <IMAGE extends Image<?, IMAGE>> ShapeModelDataset<IMAGE> load(InputStreamObjectReader<IMAGE> reader) throws IOException {
        return ShapeModelDatasets.loadASFDataset(IMMFaceDatabase.downloadAndGetPath(), reader);
    }

    private static String downloadAndGetPath() throws IOException {
        File dataset = DataUtils.getDataLocation((String)DATA_ZIP);
        if (!dataset.exists()) {
            dataset.getParentFile().mkdirs();
            FileUtils.copyURLToFile((URL)new URL(DATA_DOWNLOAD_URL), (File)dataset);
        }
        return "zip:file:" + dataset.toString();
    }
}

