/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.asm;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.image.Image;
import org.openimaj.image.analysis.pyramid.SimplePyramid;
import org.openimaj.image.model.asm.ActiveShapeModel;
import org.openimaj.image.model.landmark.LandmarkModel;
import org.openimaj.image.model.landmark.LandmarkModelFactory;
import org.openimaj.math.geometry.shape.PointDistributionModel;
import org.openimaj.math.geometry.shape.PointList;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.matrix.algorithm.pca.PrincipalComponentAnalysis;
import org.openimaj.util.pair.IndependentPair;

@References(references={@Reference(author={"Cootes, T. F.", "Taylor, C. J."}, title="Statistical Models of Appearance for Computer Vision", type=ReferenceType.Unpublished, month="October", year="2001", url="http://isbe.man.ac.uk/~bim/Models/app_model.ps.gz"), @Reference(type=ReferenceType.Inproceedings, author={"Cootes, T F", "Taylor, C J", "Lanitis, A"}, title="Active shape models: Evaluation of a multi-resolution method for improving image search", year="1994", booktitle="Proc British Machine Vision Conference", pages={"327", "", "336"}, url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.141.4937&rep=rep1&type=pdf", editor={"Hancock, E"}, publisher="BMVA Press", volume="1")})
public class MultiResolutionActiveShapeModel<I extends Image<?, I>> {
    private int numLevels;
    private ActiveShapeModel<I>[] asms;
    private static float sigma = 0.5f;

    public MultiResolutionActiveShapeModel(ActiveShapeModel<I>[] asms) {
        this.numLevels = asms.length;
        this.asms = asms;
    }

    public static <I extends Image<?, I>> MultiResolutionActiveShapeModel<I> trainModel(int numLevels, PrincipalComponentAnalysis.ComponentSelector selector, List<IndependentPair<PointList, I>> data, PointDistributionModel.Constraint constraint, LandmarkModelFactory<I> factory) {
        int level;
        int nPoints = ((PointList)data.get(0).firstObject()).size();
        LandmarkModel[][] ppms = new LandmarkModel[numLevels][nPoints];
        for (int i = 0; i < data.size(); ++i) {
            SimplePyramid pyr = SimplePyramid.createGaussianPyramid((Image)((Image)data.get(i).secondObject()), (float)sigma, (int)numLevels);
            PointList pl = (PointList)data.get(i).firstObject();
            for (level = 0; level < numLevels; ++level) {
                Matrix scaling = TransformUtilities.scaleMatrix((double)(1.0 / Math.pow(2.0, level)), (double)(1.0 / Math.pow(2.0, level)));
                PointList tfpl = pl.transform(scaling);
                Image image = pyr.pyramid[level];
                for (int j = 0; j < nPoints; ++j) {
                    if (ppms[level][j] == null) {
                        ppms[level][j] = factory.createLandmarkModel((float)Math.pow(2.0, level));
                    }
                    ppms[level][j].updateModel(image, tfpl.get(j), tfpl);
                }
            }
        }
        ArrayList<Object> pls = new ArrayList<Object>();
        for (IndependentPair<PointList, I> i : data) {
            pls.add(i.firstObject());
        }
        PointDistributionModel pdm = new PointDistributionModel(constraint, pls);
        pdm.setNumComponents(selector);
        ActiveShapeModel[] asms = new ActiveShapeModel[numLevels];
        for (level = 0; level < numLevels; ++level) {
            asms[level] = new ActiveShapeModel(pdm, ppms[level]);
        }
        return new MultiResolutionActiveShapeModel<I>(asms);
    }

    public ActiveShapeModel.IterationResult fit(I initialImage, PointList initialShape) {
        SimplePyramid pyr = SimplePyramid.createGaussianPyramid(initialImage, (float)sigma, (int)this.numLevels);
        Matrix scaling = TransformUtilities.scaleMatrix((double)(1.0 / Math.pow(2.0, this.numLevels - 1)), (double)(1.0 / Math.pow(2.0, this.numLevels - 1)));
        PointList shape = initialShape.transform(scaling);
        Matrix pose = null;
        double[] parameters = null;
        double fit = 0.0;
        for (int level = this.numLevels - 1; level >= 0; --level) {
            Image image = pyr.pyramid[level];
            ActiveShapeModel<Image> asm = this.asms[level];
            ActiveShapeModel.IterationResult newData = asm.fit(image, shape);
            scaling = level == 0 ? Matrix.identity((int)3, (int)3) : TransformUtilities.scaleMatrix((double)2.0, (double)2.0);
            shape = newData.shape.transform(scaling);
            pose = newData.pose.times(scaling);
            fit = newData.fit;
            parameters = newData.parameters;
        }
        return new ActiveShapeModel.IterationResult(pose, shape, fit, parameters);
    }

    public PointDistributionModel getPDM() {
        return this.asms[0].getPDM();
    }
}

