/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.asm;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.image.Image;
import org.openimaj.image.model.landmark.LandmarkModel;
import org.openimaj.image.model.landmark.LandmarkModelFactory;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.PointDistributionModel;
import org.openimaj.math.geometry.shape.PointList;
import org.openimaj.math.matrix.algorithm.pca.PrincipalComponentAnalysis;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.ObjectFloatPair;

@References(references={@Reference(author={"Cootes, T. F.", "Taylor, C. J."}, title="Statistical Models of Appearance for Computer Vision", type=ReferenceType.Unpublished, month="October", year="2001", url="http://isbe.man.ac.uk/~bim/Models/app_model.ps.gz"), @Reference(type=ReferenceType.Inproceedings, author={"T. F. Cootes", "C. J. Taylor"}, title="Active Shape Models", year="1992", booktitle="in Proceedings of the British Machine Vision Conference")})
public class ActiveShapeModel<I extends Image<?, I>> {
    private PointDistributionModel pdm;
    private LandmarkModel<I>[] landmarkModels;
    private int maxIter = 50;
    private double inlierPercentage = 0.9;

    public ActiveShapeModel(PointDistributionModel pdm, LandmarkModel<I>[] landmarkModels) {
        this.pdm = pdm;
        this.landmarkModels = landmarkModels;
    }

    public static <I extends Image<?, I>> ActiveShapeModel<I> trainModel(PrincipalComponentAnalysis.ComponentSelector selector, List<IndependentPair<PointList, I>> data, PointDistributionModel.Constraint constraint, LandmarkModelFactory<I> factory) {
        int nPoints = ((PointList)data.get(0).firstObject()).size();
        LandmarkModel[] ppms = new LandmarkModel[nPoints];
        for (int i = 0; i < data.size(); ++i) {
            for (int j = 0; j < nPoints; ++j) {
                if (ppms[j] == null) {
                    ppms[j] = factory.createLandmarkModel();
                }
                PointList pl = (PointList)data.get(i).firstObject();
                ppms[j].updateModel((Image)data.get(i).secondObject(), pl.get(j), pl);
            }
        }
        ArrayList<Object> pls = new ArrayList<Object>();
        for (IndependentPair<PointList, I> i : data) {
            pls.add(i.firstObject());
        }
        PointDistributionModel pdm = new PointDistributionModel(constraint, pls);
        pdm.setNumComponents(selector);
        return new ActiveShapeModel<I>(pdm, ppms);
    }

    public IterationResult performIteration(I image, PointList currentShape) {
        PointList newShape = new PointList(new Point2d[0]);
        int inliers = 0;
        int outliers = 0;
        for (int i = 0; i < this.landmarkModels.length; ++i) {
            ObjectFloatPair<Point2d> newBest = this.landmarkModels[i].updatePosition(image, currentShape.get(i), currentShape);
            newShape.points.add(newBest.first);
            float percentageFromStart = newBest.second;
            if ((double)percentageFromStart < 0.5) {
                ++inliers;
                continue;
            }
            ++outliers;
        }
        double score = (double)inliers / (double)(inliers + outliers);
        IndependentPair newModelParams = this.pdm.fitModel(newShape);
        Matrix pose = (Matrix)newModelParams.firstObject();
        double[] parameters = (double[])newModelParams.secondObject();
        newShape = this.pdm.generateNewShape(parameters).transform(pose);
        return new IterationResult(pose, newShape, score, parameters);
    }

    public IterationResult fit(I image, PointList initialShape) {
        IterationResult ir = this.performIteration(image, initialShape);
        for (int count = 0; ir.fit < this.inlierPercentage && count < this.maxIter; ++count) {
            ir = this.performIteration(image, ir.shape);
        }
        return ir;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    public double getInlierPercentage() {
        return this.inlierPercentage;
    }

    public void setInlierPercentage(double inlierPercentage) {
        this.inlierPercentage = inlierPercentage;
    }

    public PointDistributionModel getPDM() {
        return this.pdm;
    }

    public LandmarkModel<I>[] getLandmarkModels() {
        return this.landmarkModels;
    }

    public static class IterationResult {
        public double fit;
        public PointList shape;
        public Matrix pose;
        public double[] parameters;

        protected IterationResult(Matrix pose, PointList shape, double fit, double[] parameters) {
            this.pose = pose;
            this.shape = shape;
            this.fit = fit;
            this.parameters = parameters;
        }
    }
}

