/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.feature.global.SharpPixelProportion;
import org.openimaj.image.processor.GridProcessor;
import org.openimaj.math.util.FloatArrayStatsUtils;

@Reference(type=ReferenceType.Inproceedings, author={"Che-Hua Yeh", "Yuan-Chen Ho", "Brian A. Barsky", "Ming Ouhyoung"}, title="Personalized Photograph Ranking and Selection System", year="2010", booktitle="Proceedings of ACM Multimedia", pages={"211", "220"}, month="October", customData={"location", "Florence, Italy"})
public class YehBokehEstimator
implements ImageAnalyser<FImage>,
FeatureVectorProvider<DoubleFV> {
    Sharpness sharpProcessor = new Sharpness();
    GreyLevelVariance varProcessor = new GreyLevelVariance();
    int nBlocksX = 5;
    int nBlocksY = 5;
    float varThreshold = 0.1f;
    float sharpnessThreshold = 0.5f;
    float lowerBound = 0.3f;
    float upperBound = 0.7f;
    double bokeh;

    public YehBokehEstimator() {
    }

    public YehBokehEstimator(int nBlocksX, int nBlocksY, float varThreshold, float sharpnessThreshold, float lowerBound, float upperBound) {
        this.nBlocksX = nBlocksX;
        this.nBlocksY = nBlocksY;
        this.varThreshold = varThreshold;
        this.sharpnessThreshold = sharpnessThreshold;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.bokeh});
    }

    public void analyseImage(FImage image) {
        FImage sharpness = (FImage)image.process((GridProcessor)this.sharpProcessor);
        FImage variance = (FImage)image.process((GridProcessor)this.varProcessor);
        double Qbokeh = 0.0;
        int validBlocks = 0;
        for (int y = 0; y < sharpness.height; ++y) {
            for (int x = 0; x < sharpness.width; ++x) {
                if (!(variance.pixels[y][x] >= this.varThreshold)) continue;
                Qbokeh += (double)sharpness.pixels[y][x] > 0.5 ? 1.0 : 0.0;
                ++validBlocks;
            }
        }
        this.bokeh = (Qbokeh /= (double)validBlocks) >= (double)this.lowerBound && Qbokeh <= (double)this.upperBound ? 1.0 : 0.0;
    }

    class GreyLevelVariance
    implements GridProcessor<Float, FImage> {
        GreyLevelVariance() {
        }

        public int getHorizontalGridElements() {
            return YehBokehEstimator.this.nBlocksX;
        }

        public int getVerticalGridElements() {
            return YehBokehEstimator.this.nBlocksY;
        }

        public Float processGridElement(FImage patch) {
            return Float.valueOf(FloatArrayStatsUtils.var((float[][])patch.pixels));
        }
    }

    class Sharpness
    implements GridProcessor<Float, FImage> {
        SharpPixelProportion bpp = new SharpPixelProportion();

        Sharpness() {
        }

        public int getHorizontalGridElements() {
            return YehBokehEstimator.this.nBlocksX;
        }

        public int getVerticalGridElements() {
            return YehBokehEstimator.this.nBlocksY;
        }

        public Float processGridElement(FImage patch) {
            patch.analyseWith((ImageAnalyser)this.bpp);
            return Float.valueOf((float)this.bpp.getBlurredPixelProportion());
        }
    }
}

