/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.procedure.TObjectFloatProcedure;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.saliency.YehSaliency;
import org.openimaj.math.geometry.point.Point2dImpl;

@Reference(type=ReferenceType.Inproceedings, author={"Che-Hua Yeh", "Yuan-Chen Ho", "Brian A. Barsky", "Ming Ouhyoung"}, title="Personalized Photograph Ranking and Selection System", year="2010", booktitle="Proceedings of ACM Multimedia", pages={"211", "220"}, month="October", customData={"location", "Florence, Italy"})
public class RuleOfThirds
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    private static final double SIGMA = 0.17;
    private static final Point2dImpl[] powerPoints = RuleOfThirds.getPowerPoints();
    YehSaliency saliencyGenerator;
    private double asSum;
    private double aseSum;

    public RuleOfThirds() {
        this.saliencyGenerator = new YehSaliency();
    }

    public RuleOfThirds(float saliencySigma, float segmenterSigma, float k, int minSize) {
        this.saliencyGenerator = new YehSaliency(saliencySigma, segmenterSigma, k, minSize);
    }

    public DoubleFV getFeatureVector() {
        if (this.asSum == 0.0) {
            new DoubleFV(new double[]{0.0});
        }
        return new DoubleFV(new double[]{this.aseSum / this.asSum});
    }

    public void analyseImage(MBFImage image) {
        final int width = image.getWidth();
        final int height = image.getHeight();
        image.analyseWith((ImageAnalyser)this.saliencyGenerator);
        TObjectFloatHashMap<ConnectedComponent> componentMap = this.saliencyGenerator.getSaliencyComponents();
        this.asSum = 0.0;
        this.aseSum = 0.0;
        componentMap.forEachEntry((TObjectFloatProcedure)new TObjectFloatProcedure<ConnectedComponent>(){

            public boolean execute(ConnectedComponent c, float s) {
                double as = (float)c.calculateArea() * s;
                double D = RuleOfThirds.this.closestDistance((PixelSet)c, width, height);
                RuleOfThirds.this.asSum += as;
                RuleOfThirds.this.aseSum += as * Math.exp(-(D * D) / 0.34);
                return true;
            }
        });
    }

    private double closestDistance(PixelSet cc, int width, int height) {
        double[] centroid = cc.calculateCentroid();
        double minDistance = Double.MAX_VALUE;
        for (Point2dImpl pt : powerPoints) {
            double dx = centroid[0] / (double)width - (double)pt.x;
            double dy = centroid[1] / (double)width - (double)pt.y;
            double d = dx * dx + dy * dy;
            if (!(d < minDistance)) continue;
            minDistance = d;
        }
        return Math.sqrt(minDistance);
    }

    private static Point2dImpl[] getPowerPoints() {
        return new Point2dImpl[]{new Point2dImpl(0.33333334f, 0.33333334f), new Point2dImpl(0.6666667f, 0.33333334f), new Point2dImpl(0.33333334f, 0.6666667f), new Point2dImpl(0.6666667f, 0.6666667f)};
    }
}

