/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.EnumFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.analyser.PixelAnalyser;

@Reference(type=ReferenceType.Inproceedings, author={"Hasler, David", "S\\\"{u}sstrunk, Sabine"}, title="Measuring {C}olourfulness in {N}atural {I}mages", year="2003", booktitle="Proc. {IS}&{T}/{SPIE} {E}lectronic {I}maging 2003: {H}uman {V}ision and {E}lectronic {I}maging {VIII}", pages={"87", "", "95"}, volume="5007", url="http://infoscience.epfl.ch/record/33994/files/HaslerS03.pdf?version=1", customData={"details", "http://infoscience.epfl.ch/record/33994", "documenturl", "http://infoscience.epfl.ch/record/33994/files/HaslerS03.pdf", "doi", "10.1117/12.477378", "keywords", "IVRG; colorfulness; image quality; image attributes; colourfulness", "location", "San Jose, CA", "oai-id", "oai:infoscience.epfl.ch:33994", "oai-set", "conf; fulltext; fulltext-public", "review", "NON-REVIEWED", "status", "PUBLISHED", "unit", "LCAV IVRG"})
public class Colorfulness
implements PixelAnalyser<Float[]>,
FeatureVectorProvider<DoubleFV> {
    SummaryStatistics rgStats = new SummaryStatistics();
    SummaryStatistics ybStats = new SummaryStatistics();

    public void analysePixel(Float[] pixel) {
        float r = pixel[0].floatValue();
        float g = pixel[1].floatValue();
        float b = pixel[2].floatValue();
        float rg = r - g;
        float yb = 0.5f * (r + g) - b;
        this.rgStats.addValue((double)rg);
        this.ybStats.addValue((double)yb);
    }

    public ColorfulnessAttr getColorfulnessAttribute() {
        return ColorfulnessAttr.getAttr(this.getColorfulness());
    }

    public double getColorfulness() {
        double var_rg = this.rgStats.getVariance();
        double var_yb = this.ybStats.getVariance();
        double mean_rg = this.rgStats.getMean();
        double mean_yb = this.ybStats.getMean();
        double stddev = Math.sqrt(var_rg + var_yb);
        double mean = Math.sqrt(mean_rg * mean_rg + mean_yb * mean_yb);
        return stddev + 0.3 * mean;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.getColorfulness()});
    }

    public void reset() {
        this.rgStats.clear();
        this.ybStats.clear();
    }

    @Reference(type=ReferenceType.Inproceedings, author={"Hasler, David", "S\\\"{u}sstrunk, Sabine"}, title="Measuring {C}olourfulness in {N}atural {I}mages", year="2003", booktitle="Proc. {IS}&{T}/{SPIE} {E}lectronic {I}maging 2003: {H}uman {V}ision and {E}lectronic {I}maging {VIII}", pages={"87", "", "95"}, volume="5007", url="http://infoscience.epfl.ch/record/33994/files/HaslerS03.pdf?version=1", customData={"details", "http://infoscience.epfl.ch/record/33994", "documenturl", "http://infoscience.epfl.ch/record/33994/files/HaslerS03.pdf", "doi", "10.1117/12.477378", "keywords", "IVRG; colorfulness; image quality; image attributes; colourfulness", "location", "San Jose, CA", "oai-id", "oai:infoscience.epfl.ch:33994", "oai-set", "conf; fulltext; fulltext-public", "review", "NON-REVIEWED", "status", "PUBLISHED", "unit", "LCAV IVRG"})
    public static enum ColorfulnessAttr implements FeatureVectorProvider<EnumFV<ColorfulnessAttr>>
    {
        NOT(0.0),
        SLIGHTLY(0.058823529411764705),
        MODERATELY(0.12941176470588237),
        AVERAGELY(0.17647058823529413),
        QUITE(0.23137254901960785),
        HIGHLY(0.3215686274509804),
        EXTREMELY(0.42745098039215684);

        private double threshold;

        private ColorfulnessAttr(double val) {
            this.threshold = val;
        }

        public static ColorfulnessAttr getAttr(double val) {
            ColorfulnessAttr[] attrs = ColorfulnessAttr.values();
            for (int i = attrs.length - 1; i >= 0; --i) {
                if (!(val >= attrs[i].threshold)) continue;
                return attrs[i];
            }
            return null;
        }

        public EnumFV<ColorfulnessAttr> getFeatureVector() {
            return new EnumFV((Enum)this);
        }
    }
}

