/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.connectedcomponent.proc;

import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;

public class BasicShapeDescriptor
implements ConnectedComponentProcessor,
FeatureVectorProvider<DoubleFV> {
    public double area;
    public double cx;
    public double cy;
    public double direction;
    public double elongatedness;
    public double compactness;
    public double chfit;
    public double cornerEst;

    public void process(ConnectedComponent cc) {
        this.area = cc.calculateArea();
        double[] c = cc.calculateCentroid();
        this.cx = c[0];
        this.cy = c[1];
        this.direction = cc.calculateDirection();
        this.elongatedness = cc.calculateOrientatedBoundingBoxAspectRatio();
        float edge_length = cc.getOuterBoundary().size();
        this.compactness = edge_length * edge_length / (float)new ConnectedComponent(cc.toPolygon()).calculateArea();
        this.chfit = this.area > 4.0 ? new ConnectedComponent(cc.toPolygon()).calculatePercentageConvexHullFit() : 1.0;
        this.cornerEst = this.area > 100.0 ? (double)cc.estimateNumberOfVertices(3, 10) : this.area;
    }

    public double[] getFeatureVectorArray() {
        return new double[]{this.area, this.cx, this.cy, this.direction, this.elongatedness, this.compactness, this.chfit, this.cornerEst};
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(this.getFeatureVectorArray());
    }

    public static enum BasicShapeDescriptorType {
        AREA{

            @Override
            public DoubleFV getFeatureVector(BasicShapeDescriptor desc) {
                return new DoubleFV(new double[]{desc.area});
            }
        }
        ,
        CENTROID{

            @Override
            public DoubleFV getFeatureVector(BasicShapeDescriptor desc) {
                return new DoubleFV(new double[]{desc.cx, desc.cy});
            }
        }
        ,
        DIRECTION{

            @Override
            public DoubleFV getFeatureVector(BasicShapeDescriptor desc) {
                return new DoubleFV(new double[]{desc.direction});
            }
        }
        ,
        ELONGATEDNESS{

            @Override
            public DoubleFV getFeatureVector(BasicShapeDescriptor desc) {
                return new DoubleFV(new double[]{desc.elongatedness});
            }
        }
        ,
        COMPACTNESS{

            @Override
            public DoubleFV getFeatureVector(BasicShapeDescriptor desc) {
                return new DoubleFV(new double[]{desc.compactness});
            }
        }
        ,
        CHFIT{

            @Override
            public DoubleFV getFeatureVector(BasicShapeDescriptor desc) {
                return new DoubleFV(new double[]{desc.chfit});
            }
        }
        ,
        CORNERS{

            @Override
            public DoubleFV getFeatureVector(BasicShapeDescriptor desc) {
                return new DoubleFV(new double[]{desc.cornerEst});
            }
        };


        public abstract DoubleFV getFeatureVector(BasicShapeDescriptor var1);
    }
}

