/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.recognition;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.ml.annotation.IncrementalAnnotator;
import org.openimaj.ml.annotation.RestrictedAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;

public abstract class FaceRecogniser<FACE extends DetectedFace, PERSON>
extends IncrementalAnnotator<FACE, PERSON>
implements RestrictedAnnotator<FACE, PERSON>,
ReadWriteableBinary {
    protected FaceRecogniser() {
    }

    public abstract List<ScoredAnnotation<PERSON>> annotate(FACE var1, Collection<PERSON> var2);

    public ScoredAnnotation<PERSON> annotateBest(FACE object, Collection<PERSON> restrict) {
        List<ScoredAnnotation<PERSON>> pot = this.annotate(object, restrict);
        if (pot == null || pot.size() == 0) {
            return null;
        }
        Collections.sort(pot);
        return pot.get(0);
    }

    public abstract List<ScoredAnnotation<PERSON>> annotate(FACE var1);

    public ScoredAnnotation<PERSON> annotateBest(FACE object) {
        List<ScoredAnnotation<PERSON>> pot = this.annotate(object);
        if (pot == null || pot.size() == 0) {
            return null;
        }
        return pot.get(0);
    }

    public Set<PERSON> listPeople() {
        return this.getAnnotations();
    }
}

