/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature.comparison;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.face.feature.comparison.FacialFeatureComparator;
import org.openimaj.image.processing.face.feature.ltp.LtpDtFeature;

@Reference(type=ReferenceType.Article, author={"Tan, Xiaoyang", "Triggs, Bill"}, title="Enhanced local texture feature sets for face recognition under difficult lighting conditions", year="2010", journal="Trans. Img. Proc.", pages={"1635", "1650"}, url="http://dx.doi.org/10.1109/TIP.2010.2042645", month="June", number="6", publisher="IEEE Press", volume="19")
public class ReversedLtpDtFeatureComparator
implements FacialFeatureComparator<LtpDtFeature> {
    public double compare(LtpDtFeature query, LtpDtFeature target) {
        List slicePixels = target.ltpPixels;
        float distance = 0.0f;
        FImage[] distanceMaps = query.getDistanceMaps();
        for (int i = 0; i < distanceMaps.length; ++i) {
            List pixels = (List)slicePixels.get(i);
            double sliceDistance = 0.0;
            if (distanceMaps[i] == null || pixels == null) continue;
            for (Pixel p : pixels) {
                sliceDistance += (double)distanceMaps[i].pixels[p.y][p.x];
            }
            distance = (float)((double)distance + sliceDistance);
        }
        return distance;
    }

    public boolean isDistance() {
        return true;
    }

    public void readBinary(DataInput in) throws IOException {
    }

    public byte[] binaryHeader() {
        return null;
    }

    public void writeBinary(DataOutput out) throws IOException {
    }

    public String toString() {
        return "ReversedLtpDtFeatureComparator";
    }
}

